
<?php

use App\Models\About;
use App\Models\Activity;
use App\Models\Contact;
use Illuminate\Support\Facades\Storage;
use Intervention\Image\Facades\Image;

function uploadSlideImage($requestedImage, $folder)
{
    if ($requestedImage) {
        $image_name = time() . '.' . $requestedImage->getClientOriginalExtension();
        $imgFile = \Intervention\Image\Facades\Image::make($requestedImage->getRealPath());
        $imgFile->resize(1920, 1281, function ($constraint) {
            $constraint->aspectRatio();
        });
        $imgFile->stream(); // <-- Key point
        Storage::disk('public')->put($folder . '/' . '/' . $image_name, $imgFile, 'public');
    } else {
        $image_name = "No-image.png";
    }

    return $image_name;
}
function uploadTeamImageFile($requestedImage, $folder)
{
    if ($requestedImage) {
        $image_name = time() . '.' . $requestedImage->getClientOriginalExtension();
        $imgFile = \Intervention\Image\Facades\Image::make($requestedImage->getRealPath());
        $imgFile->resize(233, 350, function ($constraint) {
            $constraint->aspectRatio();
        });
        $imgFile->stream(); // <-- Key point
        Storage::disk('public')->put($folder . '/' . '/' . $image_name, $imgFile, 'public');
    } else {
        $image_name = "No-image.png";
    }

    return $image_name;
}
function uploadImageFile($requestedImage, $folder)
{
    if ($requestedImage) {
        $image_name = time() . '.' . $requestedImage->getClientOriginalExtension();
        $imgFile = \Intervention\Image\Facades\Image::make($requestedImage->getRealPath());
        $imgFile->resize(850, 500, function ($constraint) {
            $constraint->aspectRatio();
        });
        $imgFile->stream(); // <-- Key point
        Storage::disk('public')->put($folder . '/' . '/' . $image_name, $imgFile, 'public');
    } else {
        $image_name = "No-image.png";
    }

    return $image_name;
}

function uploadActivityImage($requestedImage, $folder)
{
    if ($requestedImage) {
        $image_name = time() . '.' . $requestedImage->getClientOriginalExtension();
        $imgFile = \Intervention\Image\Facades\Image::make($requestedImage->getRealPath());
        $imgFile->resize(733, 500, function ($constraint) {
            $constraint->aspectRatio();
        });
        $imgFile->stream(); // <-- Key point
        Storage::disk('public')->put($folder . '/' . '/' . $image_name, $imgFile, 'public');
    } else {
        $image_name = "No-image.png";
    }

    return $image_name;
}

function delete_image($folderName, $modelName)
{
    if (is_file(public_path('storage/' . $folderName . '/' . '' . $modelName->image))) {
        unlink(public_path('storage/' . $folderName . '/' . '' . $modelName->image));
    }
    return true;
}

function updateImage($requestedImg, $folderName, $modelName)
{
    if ($requestedImg) {

        if (is_file(public_path('storage/' . $folderName . '/' . '' . $modelName->image))) {
            unlink(public_path('storage/' . $folderName . '/' . '' . $modelName->image));
            $modelName->image = null;
            $modelName->save();
        }

        $image = $request->file('image');

        $input['file'] = time() . '.' . $image->getClientOriginalExtension();

        $imgFile = Image::make($image->getRealPath());

        $imgFile->resize(800, 250, function ($constraint) {
            $constraint->aspectRatio();
        });
        $imgFile->stream(); // <-- Key point
        Storage::disk('public')->put($folder . '/' . '/' . $input['file'], $imgFile, 'public');

        $modelName->image = $input['file'];
        $save_img = $modelName->save();

        return $save_img;
    }

}

function getContact()
{
    $contact = Contact::get()->first();
    return $contact;
}

function getAbout()
{
    $about = About::get()->first();
    return $about;
}

function getActivities()
{
    $activities = Activity::with('images')->orderByDesc('id')->get()->take(3);
    return $activities;
}