<?php

namespace App\Http\Controllers;

use App\Models\About;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Storage;
use Illuminate\Support\Str;
use Intervention\Image\Facades\Image;

class AboutController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
        $abouts = About::get();
        return view('about.index', compact('abouts'));
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {

    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        $data = $request->validate([
            'about_text' => 'required',
            'mission' => 'required',
            'goal' => 'required',
            'objective' => 'required',
            'mandat' => 'nullable',
            'image' => 'nullable',
        ]);

        $image = $request->file('image');

        $img_name = uploadImageFile($image, 'abouts');

        $data['slug'] = Str::random(4) . time();
        $data['image'] = $img_name;
        About::create($data);

        return redirect()->back()->with("message", "Données Enregistrées");
    }

    /**
     * Display the specified resource.
     *
     * @param  \App\Models\About  $about
     * @return \Illuminate\Http\Response
     */
    public function show(About $about)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  \App\Models\About  $about
     * @return \Illuminate\Http\Response
     */
    public function edit(About $about)
    {
        return view('about.edit', compact('about'));
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  \App\Models\About  $about
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, About $about)
    {
        $data = $request->validate([
            'about_text' => 'required',
            'mission' => 'required',
            'goal' => 'required',
            'objective' => 'required',
            'mandat' => 'nullable',
            'image' => 'nullable',
        ]);
        $about->update($data);

        return redirect()->back()->with("message", "Données Enregistrées");

    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  \App\Models\About  $about
     * @return \Illuminate\Http\Response
     */
    public function destroy(About $about)
    {
        //
    }

    public function addImage(Request $request, About $about)
    {
        if ($request->hasFile('image')) {

            if (is_file(public_path('$storage/abouts/' . '' . $about->image))) {
                unlink(public_path('$storage/abouts/' . '' . $about->image));
                $about->image = null;
                $about->save();
            }

            $image = $request->file('image');

            $input['file'] = time() . '.' . $image->getClientOriginalExtension();

            $imgFile = Image::make($image->getRealPath());

            $imgFile->resize(800, 500, function ($constraint) {
                $constraint->aspectRatio();
            });
            $imgFile->stream(); // <-- Key point
            Storage::disk('public')->put('abouts/' . '/' . $input['file'], $imgFile, 'public');

            $about->image = $input['file'];
            $about->save();
        }

        return redirect()->back()->with('message', 'Image ajoutée');
    }

    public function deleteImage(About $about)
    {
        if (is_file(public_path('storage/abouts/' . '' . $about->image))) {
            unlink(public_path('storage/abouts/' . '' . $about->image));
        }
        $about->image = null;
        $about->save();

        return redirect()->back()->with('message', 'Image supprimée');
    }
}
