<?php

namespace App\Http\Controllers;

use App\Models\Activity;
use App\Models\ActivityImage;
use Illuminate\Http\Request;
use Illuminate\Support\Str;
use Storage;

class ActivityController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
        $activities = Activity::orderBy('id')->paginate(10);

        return view('activities.index', compact('activities'));
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        //
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        $request->validate([
            'name' => 'required|string|max:255',
            'description' => 'nullable',
            'image' => 'nullable',
            'start_date' => 'date',
        ]);

        Activity::create([
            "title" => $request->name,
            "description" => $request->description,
            "started_at" => $request->start_date,
            "slug" => Str::random(4) . time(),
        ]);

        return redirect()->back()->with("message", "Données Enregistrées");

    }

    /**
     * Display the specified resource.
     *
     * @param  \App\Models\Activity  $activity
     * @return \Illuminate\Http\Response
     */
    public function show(Activity $activity)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  \App\Models\Activity  $activity
     * @return \Illuminate\Http\Response
     */
    public function edit(Activity $activity)
    {
        return view('activities.edit', compact('activity'));
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  \App\Models\Activity  $activity
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, Activity $activity)
    {
        $data = $request->validate([
            'name' => 'required',
            'description' => 'nullable',
            'start_date' => 'date',
        ]);
        $activity->update([
            'title' => $data["name"],
            'description' => $data["description"],
            'started_at' => $data["start_date"],
        ]);

        return redirect()->back()->with("message", "Données Enregistrées");
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  \App\Models\Activity  $activity
     * @return \Illuminate\Http\Response
     */
    public function destroy(Activity $activity)
    {
        $activity->delete();

        return redirect(route('activities.index'))->with("message", "Données supprimées");
    }

    public function store_image(Request $request, Activity $activity)
    {

        $data = $request->validate([
            'image' => 'nullable|image|mimes:jpeg,png,jpg,gif,svg|max:5048',
        ]);

        $image = $request->file('image');
        $activityImg = uploadActivityImage($image, 'activities');
        $slug = Str::random(4) . time();
        ActivityImage::create([
            'slug' => $slug,
            'activity_id' => $activity->id,
            'image' => $activityImg,
        ]);

        return redirect()->back()->with("message", "Données Enregistrées");

    }

    public function delete_image(ActivityImage $image)
    {

        delete_image('activities', $image);
        $image->delete();

        return redirect()->back()->with('message', 'Données Supprimées');
    }
}
