<?php

namespace App\Http\Controllers;

use App\Models\Contact;
use Illuminate\Http\Request;
use Illuminate\Support\Str;

class ContactController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
        $contacts = Contact::orderBy('id')->paginate(10);

        return view('contacts.index', compact('contacts'));
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        //
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        $data = $request->validate([
            'telephone' => 'required|max:50|min:3',
            'email' => 'required|email|max:50',
            'facebook' => 'nullable',
            'twitter' => 'nullable',
            'tiktok' => 'nullable',
            'instagram' => 'nullable',
            'address' => 'required|max:255',
        ]);
        $data['slug'] = Str::random(4) . time();
        $data['reference'] = 'C' . Str::random(2) . time();

        $countContactRows = Contact::count();
        if ($countContactRows > 0) {
            return redirect()->back()->with('warning', 'Données Enregistrées');
        } else {
            Contact::create($data);
            return redirect()->back()->with('message', 'Données Enregistrées');
        }
    }

    /**
     * Display the specified resource.
     *
     * @param  \App\Models\Contact  $contact
     * @return \Illuminate\Http\Response
     */
    public function show(Contact $contact)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  \App\Models\Contact  $contact
     * @return \Illuminate\Http\Response
     */
    public function edit(Contact $contact)
    {
        $contacts = Contact::get();
        return view('contacts.edit', compact('contact', 'contacts'));
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  \App\Models\Contact  $contact
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, Contact $contact)
    {
        $data = $request->validate([
            'telephone' => 'required|max:50|min:3',
            'email' => 'required|email|max:50',
            'facebook' => 'nullable',
            'twitter' => 'nullable',
            'instagram' => 'nullable',
            'tiktok' => 'nullable',
            'address' => 'required',
        ]);
        $contact->update($data);

        return redirect()->back()->with('message', 'Données Enregistrées');
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  \App\Models\Contact  $contact
     * @return \Illuminate\Http\Response
     */
    public function destroy(Contact $contact)
    {
        $countContacts = Contact::count();
        if ($countContacts > 0) {

            return redirect()->back()->with('warning', 'Données non supprimées');
        } else {
            $contact->delete();

            return redirect(route('contacts.index'))->with("message", "Données supprimées");
        }
    }
}
