<?php

namespace App\Http\Controllers;

use App\Mail\ContactFormMail;
use App\Models\About;
use App\Models\Activity;
use App\Models\Contact;
use App\Models\Gallery;
use App\Models\Settings;
use App\Models\Slider;
use App\Models\Subscription;
use App\Models\Team;
use App\Models\Testimony;
use App\Models\Verse;
use App\Models\Verseimage;
use App\Models\Welcome;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Mail;
use Illuminate\Support\Str;

class FrontendController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
        $welcome = Welcome::first();
        $verse = Verse::where('date', date('Y-m-d'))->first();
        $teams = Team::orderByDesc('id')->get();
        $contact = Contact::get()->first();

        $verse_image = Verseimage::get()->first();

        $about = About::get()->first();

        $setting = Settings::get()->first();

        $testimonies = Testimony::orderByDesc('id')->get();
        $activities = Activity::with('images')->orderByDesc('id')->get()->take(3);
        $sliders = Slider::orderByDesc('id')->get();

        $galleries = Gallery::orderByDesc('id')->get();

        return view('frontend.welcome', compact('welcome', 'verse', 'teams', 'contact', 'about', 'setting', 'testimonies', 'activities', 'sliders', 'galleries', 'verse_image'));
    }

    public function about()
    {
        $about = About::get()->first();
        $teams = Team::orderByDesc('id')->get();
        return view('frontend.about', compact('about', 'teams'));
    }

    public function activities()
    {
        $activities = Activity::orderByDesc('id')->get();
        return view('frontend.activities', compact('activities'));
    }

    public function activity_show(Activity $activity)
    {
        //dd($activity);
        $activities = Activity::all()->except($activity->id)->take(5);
        return view('frontend.activity', compact('activity', 'activities'));
    }

    public function contact()
    {
        $contact = Contact::get()->first();
        return view('frontend.contact', compact('ontact'));
    }

    public function sendMail(Request $request)
    {
        $formData = $request->validate([
            'name' => 'required',
            'email' => 'required|email',
            'subject' => 'required',
            'message' => 'required',
        ]);

        Mail::to(config('app.email'))->send(new ContactFormMail($formData));

        return redirect()->back()->with('message', 'Message envoyé avec succès!');
    }

    public function subscribe(Request $request)
    {
        $formData = $request->validate([
            'name' => 'required',
            'email' => 'required|email',
        ]);

        $formData['slug'] = Str::random(4) . time();
        Subscription::create($formData);

        return redirect()->back()->with('message', 'Merci de vous avoir abonné!');
    }

}
