<?php

namespace App\Http\Controllers;

use App\Models\Gallery;
use Illuminate\Http\Request;
use Illuminate\Support\Str;

class GalleryController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
        $galleries = Gallery::orderBy('id')->paginate(20);

        return view('galleries.index', compact('galleries'));
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        //
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        $data = $request->validate([
            'caption'    => 'required',
            'image' => 'nullable|image|mimes:jpeg,png,jpg,gif,svg|max:5048'
        ]);

        $slug = Str::random(4) . time();

        $image = $request->file('image');

        $uploadedImg = uploadImageFile($image,'galleries');

        Gallery::create([
            'slug'       => $slug,
            'image'      => $uploadedImg,
            'caption'    => $request->caption,
        ]);

        return redirect()->back()->with('message', 'Données Enregistrées');
    }

    /**
     * Display the specified resource.
     *
     * @param  \App\Models\Gallery  $gallery
     * @return \Illuminate\Http\Response
     */
    public function show(Gallery $gallery)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  \App\Models\Gallery  $gallery
     * @return \Illuminate\Http\Response
     */
    public function edit(Gallery $gallery)
    {
        return view('galleries.edit', compact('gallery'));
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  \App\Models\Gallery  $gallery
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, Gallery $gallery)
    {
        $data = $request->validate([
            'caption' => 'required'
        ]);

        $gallery->update(['caption' => $data['caption']]);

        return back()->with('message', 'Données Enregistrées');
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  \App\Models\Gallery  $gallery
     * @return \Illuminate\Http\Response
     */
    public function destroy(Gallery $gallery)
    {
        $gallery->delete();

        return redirect()->route('galleries.index')->with('message', 'Données Supprimées');
    }

    public function addImage(Request $request, Gallery $gallery)
    {
        $data = $request->validate([
            'image' => 'required|image|mimes:jpeg,png,jpg,gif,svg|max:5048'
        ]);

        $image = $request->file('image');

        $uploadedImg = uploadImageFile($image,'galleries');

        $gallery->update(['image' => $uploadedImg]);

        return back()->with('message', 'Image ajoutée');
    }


    public function deleteImage(Gallery $gallery)
    {

        delete_image('galleries',$gallery);
        $gallery->update(['image' => null]);

        return redirect()->back()->with('message', 'Image supprimée');
    }
}
