<?php

namespace App\Http\Controllers;

use App\Models\Settings;
use Illuminate\Http\Request;
use Illuminate\Support\Str;

class SettingsController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
        $settings = Settings::get();

        return view('settings.index',compact('settings'));
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        //
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        $data = $request->validate([
            'airtelmoney' => 'nullable|string',
            'orangemoney' => 'nullable|string',
            'mpesa' => 'nullable|string',
            'bankname' => 'nullable|string',
            'bankaccount' => 'nullable|string',
        ]);

        $data['slug'] = Str::random(4) . time();
        $countSettings = Settings::count();
        if ($countSettings > 0) {
            return redirect()->back()->with('warning', 'Données Enregistrées');
        } else {
            Settings::create($data);
            return redirect()->back()->with('message', 'Données Enregistrées');
        }
        
    }

    /**
     * Display the specified resource.
     *
     * @param  \App\Models\Settings  $settings
     * @return \Illuminate\Http\Response
     */
    public function show(Settings $setting)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  \App\Models\Settings  $settings
     * @return \Illuminate\Http\Response
     */
    public function edit(Settings $setting)
    {
        $settings = Settings::get();
        return view('settings.edit', compact('setting','settings'));
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  \App\Models\Settings  $settings
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, Settings $setting)
    {
        $data = $request->validate([
            'airtelmoney' => 'nullable|string',
            'orangemoney' => 'nullable|string',
            'mpesa' => 'nullable|string',
            'bankname' => 'nullable|string',
            'bankaccount' => 'nullable|string',
        ]);

        $setting->update($data);

        return redirect()->back()->with('message', 'Données Enregistrées');
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  \App\Models\Settings  $settings
     * @return \Illuminate\Http\Response
     */
    public function destroy(Settings $setting)
    {
        $countSettings = Settings::count();
        if ($countSettings > 0) {

            return redirect()->back()->with('warning', 'Données non supprimées');
        }
        else
        {
            $setting->delete();

            return redirect(route('contacts.index'))->with("message", "Données supprimées");
        }
    }
}
