<?php

namespace App\Http\Controllers;

use App\Models\Slider;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Storage;
use Illuminate\Support\Str;
use Intervention\Image\Facades\Image;

class SliderController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
        $sliders = Slider::orderBy('id')->paginate();
        return view('sliders.index', compact('sliders'));
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        //
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        $data = $request->validate([
            'heading1' => 'required|string',
            'heading2' => 'required|string',
            'description' => 'nullable',
            'image' => 'nullable',
        ]);

        $image = $request->file('image');

        $img_name = uploadSlideImage($image, 'sliders');

        $data['slug'] = Str::random(4) . time();
        $data['image'] = $img_name;
        Slider::create($data);

        return redirect()->back()->with("message", "Données Enregistrées");
    }

    /**
     * Display the specified resource.
     *
     * @param  \App\Models\Slider  $slider
     * @return \Illuminate\Http\Response
     */
    public function show(Slider $slider)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  \App\Models\Slider  $slider
     * @return \Illuminate\Http\Response
     */
    public function edit(Slider $slider)
    {
        return view('sliders.edit', compact('slider'));
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  \App\Models\Slider  $slider
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, Slider $slider)
    {
        $data = $request->validate([
            'heading1' => 'required|string',
            'heading2' => 'required|string',
            'description' => 'nullable',
        ]);

        $slider->update($data);

        return redirect()->back()->with("message", "Données Enregistrées");
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  \App\Models\Slider  $slider
     * @return \Illuminate\Http\Response
     */
    public function destroy(Slider $slider)
    {
        $countSliders = Slider::count();
        if ($countSliders <= 2) {

            return redirect()->back()->with('warning', 'Données non supprimées');
        } else {
            $slider->delete();

            return redirect(route('contacts.index'))->with("message", "Données supprimées");
        }
    }

    public function addImage(Request $request, Slider $slider)
    {
        if ($request->hasFile('image')) {

            if (is_file(public_path('$storage/sliders/' . '' . $slider->image))) {
                unlink(public_path('$storage/sliders/' . '' . $slider->image));
                $slider->image = null;
                $slider->save();
            }

            $image = $request->file('image');

            $input['file'] = time() . '.' . $image->getClientOriginalExtension();

            $imgFile = Image::make($image->getRealPath());

            $imgFile->resize(810.67, 620, function ($constraint) {
                $constraint->aspectRatio();
            });
            $imgFile->stream(); // <-- Key point
            Storage::disk('public')->put('sliders/' . '/' . $input['file'], $imgFile, 'public');

            $slider->image = $input['file'];
            $slider->save();
        }

        return redirect()->back()->with('message', 'Image ajoutée');
    }

    public function deleteImage(Slider $slider)
    {
        delete_image('sliders', $slider);
        $slider->update(['image' => null]);

        return redirect()->back()->with('message', 'Image supprimée');
    }
}
