<?php

namespace App\Http\Controllers;

use App\Models\Team;
use Illuminate\Http\Request;
use Illuminate\Support\Str;

class TeamController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
        $teams = Team::orderBy('name')->paginate(10);

        return view('teams.index', compact('teams'));
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        //
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        $data = $request->validate([
            'name' => 'required|string',
            'title' => 'required|string',
            'description' => 'nullable',
            'image' => 'nullable',
        ]);

        $image = $request->file('image');

        $img_name = uploadImageFile($image, 'teams');

        $data['slug'] = Str::random(4) . time();
        $data['image'] = $img_name;
        Team::create($data);

        return redirect()->back()->with("message", "Données Enregistrées");

    }

    /**
     * Display the specified resource.
     *
     * @param  \App\Models\Team  $team
     * @return \Illuminate\Http\Response
     */
    public function show(Team $team)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  \App\Models\Team  $team
     * @return \Illuminate\Http\Response
     */
    public function edit(Team $team)
    {
        return view('teams.edit', compact('team'));
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  \App\Models\Team  $team
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, Team $team)
    {
        $data = $request->validate([
            'name' => 'required|string',
            'title' => 'required|string',
            'description' => 'nullable',
        ]);

        $team->update($data);

        return redirect()->back()->with("message", "Données Enregistrées");
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  \App\Models\Team  $team
     * @return \Illuminate\Http\Response
     */
    public function destroy(Team $team)
    {
        $team->delete();

        return redirect(route('teams.index'))->with("message", "Données supprimées");
    }

    public function addImage(Request $request, Team $team)
    {
        $data = $request->validate([
            'image' => 'required|image|mimes:jpeg,png,jpg,gif,svg|max:5048',
        ]);

        $image = $request->file('image');
        $uploadedImg = uploadTeamImageFile($image, 'teams');
        $team->update(['image' => $uploadedImg]);

        return back()->with('message', 'Image ajoutée');
    }

    public function deleteImage(Team $team)
    {
        delete_image('teams', $team);
        $team->update(['image' => null]);

        return redirect()->back()->with('message', 'Image supprimée');
    }
}
