<?php

namespace App\Http\Controllers;

use App\Models\Testimony;
use Illuminate\Http\Request;
use Illuminate\Support\Str;
use Illuminate\Support\Facades\Storage;
use Intervention\Image\Facades\Image;

class TestimonyController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
        $testimonies = Testimony::orderBy('id')->paginate(20);
        return view('testimonies.index', compact('testimonies'));
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        //
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        $data = $request->validate([
            'title' => 'required|string',
            'description' => 'nullable',
            'image' => 'nullable'
        ]);

        $image = $request->file('image');

        $img_name = uploadImageFile($image,'testimonies');

        $data['slug'] = Str::random(4) . time();
        $data['image'] = $img_name;
        Testimony::create($data);

        return redirect()->back()->with("message", "Données Enregistrées");
    }

    /**
     * Display the specified resource.
     *
     * @param  \App\Models\Testimony  $testimony
     * @return \Illuminate\Http\Response
     */
    public function show(Testimony $testimony)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  \App\Models\Testimony  $testimony
     * @return \Illuminate\Http\Response
     */
    public function edit(Testimony $testimony)
    {
        return view('testimonies.edit', compact('testimony'));
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  \App\Models\Testimony  $testimony
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, Testimony $testimony)
    {
        $data = $request->validate([
            'title' => 'required|string',
            'description' => 'nullable'
        ]);

        $testimony->update($data);

        return redirect()->back()->with("message", "Données Enregistrées");
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  \App\Models\Testimony  $testimony
     * @return \Illuminate\Http\Response
     */
    public function destroy(Testimony $testimony)
    {
        $testimony->delete();

        return redirect(route('testimonys.index'))->with("message", "Données supprimées");
    }

    public function addImage(Request $request, Testimony $testimony)
    {
        if ($request->hasFile('image')) {

            if (is_file(public_path('$storage/testimonies/' . '' . $testimony->image))) {
                unlink(public_path('$storage/testimonies/' . '' . $testimony->image));
                $testimony->image = null;
                $testimony->save();
            }

            $image = $request->file('image');

            $input['file'] = time() . '.' . $image->getClientOriginalExtension();

            $imgFile = Image::make($image->getRealPath());

            $imgFile->resize(800, 250, function ($constraint) {
                $constraint->aspectRatio();
            });
            $imgFile->stream(); // <-- Key point
            Storage::disk('public')->put('testimonies/' . '/' . $input['file'], $imgFile, 'public');

            $testimony->image = $input['file'];
            $testimony->save();
        }

        return redirect()->back()->with('message', 'Image ajoutée');  
    }
    public function deleteImage(Testimony $testimony)
    {
        if (is_file(public_path('storage/testimonies/' . '' . $testimony->image))) {
            unlink(public_path('storage/testimonies/' . '' . $testimony->image));
        }
        $testimony->image = null;
        $testimony->save();

        return redirect()->back()->with('message', 'Image supprimée');
    }
}
