<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;

class UserController extends Controller
{
    public function profile()
    {
        $auth = Auth::user();

        return view('profile.index', compact('auth'));
    }

    public function update(Request $request)
    {
        $request->validate([
            'name' => 'required|string|max:255',
            'email' => 'required|string|email|max:255|unique:users,email,' . auth()->id(),
            'password' => 'sometimes|nullable|string|min:6|confirmed',
        ]);

        $user = auth()->user();
        $input = $request->except('password', 'password_confirmation');

        if (!$request->filled('password')) {
            $user->fill($input)->save();
            return back()->with('message', 'Profile Modifier avec Succès');
        }

        $user->password = bcrypt($request->password);
        $user->fill($input)->save();

        return redirect()->back()->with('message', 'Profile Modifier avec Succès');
    }

}
