<?php

namespace App\Http\Controllers;

use App\Models\Verse;
use App\Models\Verseimage;
use Illuminate\Http\Request;
use Illuminate\Support\Str;

class VerseController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
        $verses = Verse::orderBy('date')->paginate(20);

        $verse_image = Verseimage::get()->first();

        return view('verses.index', compact('verses', 'verse_image'));
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        //
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        $data = $request->validate([
            'name' => 'required|string|max:255',
            'description' => 'nullable',
            'image' => 'nullable',
            'start_date' => 'date',
        ]);

        $image = $request->file('image');

        $img_name = uploadImageFile($image, 'verses');

        Verse::create([
            'verse' => $data["name"],
            'meditation' => $data["description"],
            'date' => $data["start_date"],
            'slug' => Str::random(4) . time(),
            'image' => $img_name,
        ]);

        return redirect()->back()->with("message", "Données Enregistrées");
    }

    /**
     * Display the specified resource.
     *
     * @param  \App\Models\Verse  $verse
     * @return \Illuminate\Http\Response
     */
    public function show(Verse $verse)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  \App\Models\Verse  $verse
     * @return \Illuminate\Http\Response
     */
    public function edit(Verse $verse)
    {
        return view('verses.edit', compact('verse'));
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  \App\Models\Verse  $verse
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, Verse $verse)
    {
        $data = $request->validate([
            'name' => 'required',
            'description' => 'nullable',
            'start_date' => 'date',
        ]);
        $verse->update([
            'verse' => $data["name"],
            'meditation' => $data["description"],
            'date' => $data["start_date"],
        ]);

        return redirect()->back()->with("message", "Données Enregistrées");
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  \App\Models\Verse  $verse
     * @return \Illuminate\Http\Response
     */
    public function destroy(Verse $verse)
    {
        $verse->delete();

        return redirect(route('verses.index'))->with("message", "Données supprimées");
    }
    public function addImage(Request $request, Verse $verse)
    {
        $data = $request->validate([
            'image' => 'required|image|mimes:jpeg,png,jpg,gif,svg|max:5048',
        ]);

        $image = $request->file('image');
        $uploadedImg = uploadImageFile($image, 'verses');
        $verse->update(['image' => $uploadedImg]);

        return back()->with('message', 'Image ajoutée');
    }

    public function deleteImage(Verse $verse)
    {
        delete_image('verses', $verse);
        $verse->update(['image' => null]);

        return redirect()->back()->with('message', 'Image supprimée');
    }
}
