<?php

namespace App\Http\Controllers;

use App\Models\Verseimage;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Storage;
use Illuminate\Support\Str;

class VerseimageController extends Controller
{
    public function store(Request $request)
    {
        $data = $request->validate([
            'image' => 'nullable|image|mimes:jpeg,png,jpg,gif,svg|max:5048',
        ]);

        $slug = Str::random(4) . time();

        $image = $request->file('image');

        if ($image) {
            $image_name = time() . '.' . $image->getClientOriginalExtension();
            $imgFile = \Intervention\Image\Facades\Image::make($image->getRealPath());
            $imgFile->resize(850, 500, function ($constraint) {
                $constraint->aspectRatio();
            });
            $imgFile->stream(); // <-- Key point
            Storage::disk('public')->put('verses/images' . '/' . '/' . $image_name, $imgFile, 'public');
        } else {
            $image_name = "No-image.png";
        }

        Verseimage::create([
            'slug' => $slug,
            'image' => $image_name,
        ]);

        return redirect()->back()->with('message', 'Données Enregistrées');
    }

    public function delete_image(Verseimage $verseimage)
    {
        delete_image('verses/images', $verseimage);
        $verseimage->delete();

        return redirect()->back()->with('message', 'Données Supprimées');
    }
}
