<?php

namespace App\Http\Controllers;

use App\Models\Welcome;
use Illuminate\Http\Request;
use Illuminate\Support\Str;

class WelcomeController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
        $welcomes = Welcome::get();

        return view('welcome.index', compact('welcomes'));
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        //
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        $data = $request->validate([
            'video_link' => 'required|max:255|min:3',
            'description' => 'required',
            'image' => 'nullable|image|mimes:jpeg,png,jpg,gif,svg|max:5048',
        ]);
        
        $image = $request->file('image');
        $img_name = uploadImageFile($image,'welcomes');

        $countWelcome = Welcome::count();
        if ($countWelcome > 0) {
            return redirect()->back()->with('warning', 'Données Enregistrées');
        } else {
            Welcome::create([
                'video_link' =>$data['video_link'],
                'welcome_text' =>$data['description'],
                'slug' => Str::random(4) . time(),
                'image' => $img_name,
            ]);
            return redirect()->back()->with('message', 'Données Enregistrées');
        }
    }

    /**
     * Display the specified resource.
     *
     * @param  \App\Models\Welcome  $welcome
     * @return \Illuminate\Http\Response
     */
    public function show(Welcome $welcome)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  \App\Models\Welcome  $welcome
     * @return \Illuminate\Http\Response
     */
    public function edit(Welcome $welcome)
    {
        $welcomes = Welcome::get();

        return view('welcome.edit', compact('welcome','welcomes'));
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  \App\Models\Welcome  $welcome
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, Welcome $welcome)
    {
        $data = $request->validate([
            'video_link' => 'required|max:255|min:3',
            'description' => 'required',
        ]);
        $welcome->update([
            'video_link' =>$data['video_link'],
            'welcome_text' =>$data['description'],
        ]);

        return redirect()->back()->with('message', 'Données Enregistrées');
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  \App\Models\Welcome  $welcome
     * @return \Illuminate\Http\Response
     */
    public function destroy(Welcome $welcome)
    {
        $countWelcomes = Welcome::count();
        if ($countWelcomes > 0) {

            return redirect()->back()->with('warning', 'Données non supprimées');
        }
        else
        {
            $welcome->delete();

            return redirect(route('welcome.index'))->with("message", "Données supprimées");
        }
    }
    public function addImage(Request $request, Welcome $welcome)
    {
        $data = $request->validate([
            'image' => 'required|image|mimes:jpeg,png,jpg,gif,svg|max:5048'
        ]);

        $image = $request->file('image');
        $uploadedImg = uploadImageFile($image,'welcomes');
        $welcome->update(['image' => $uploadedImg]);

        return back()->with('message', 'Image ajoutée');
    }

    public function deleteImage(Welcome $welcome)
    {
        delete_image('welcomes',$welcome);
        $welcome->update(['image' => null]);

        return redirect()->back()->with('message', 'Image supprimée');
    }
}
