<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateSettingsTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('settings', function (Blueprint $table) {
            $table->id();
            $table->string('slug')->unique();
            $table->string('airtelmoney')->nullable()->unique();
            $table->string('orangemoney')->nullable()->unique();
            $table->string('mpesa')->nullable()->unique();
            $table->string('bankname')->nullable()->unique();
            $table->string('bankaccount')->nullable()->unique();
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('settings');
    }
}
