@extends('layouts.default', ['current' => 'about'])
@section('page_title', 'Modifier about')
@section('breadcrumb')
    <div class="content-header">
        <div class="container-fluid">
            <div class="row justify-content-end mb-2">
                <div class="col-sm-6">
                    <ol class="breadcrumb float-sm-right">
                        <li class="breadcrumb-item"><a href="{{ route('dashboard') }}">Dashboard</a></li>
                        <li class="breadcrumb-item"><a href="{{ route('abouts.index') }}">Qui sommes-nous?</a></li>
                        <li class="breadcrumb-item active">Modifier </li>
                    </ol>
                </div>
            </div>
        </div>
    </div>
@endsection
@section('content')
    <div class="row">
        <div class="col-md-8 mb-3">
            <div class="card">
                <div class="card-header card-outline card-primary">
                    <h3 class="card-title">Informations générales</h3>
                </div>
                <form role="form" method="POST" action="{{ route('abouts.update', $about) }}">
                    @csrf
                    @method('PUT')
                    <div class="card-body">
                        <div class="row">
                            <div class="col-md-12">
                                <div class="form-group">
                                    <label for="about_text">Qui sommes-nous texte</label>
                                    <textarea class="form-control" id="about_text" name="about_text" placeholder="Qui sommes-nous texte...">
                                              {{ $about->about_text ? html_entity_decode($about->about_text) : old('about_text') }}
                                    </textarea>
                                    @error('about_text')
                                        <span class="small text-danger" role="alert">{{ $message }}</span>
                                    @enderror
                                </div>
                            </div>
                        </div>
                        <div class="row">
                            <div class="col-md-12">
                                <div class="form-group">
                                    <label for="objective">Objectif</label>
                                    <textarea class="form-control" id="objective" name="objective" placeholder="Objectif...">
                                              {{ $about->objective ? html_entity_decode($about->objective) : old('objective') }}
                                    </textarea>
                                    @error('objective')
                                        <span class="small text-danger" role="alert">{{ $message }}</span>
                                    @enderror
                                </div>
                            </div>
                        </div>
                        <div class="row">
                            <div class="col-md-12">
                                <div class="form-group">
                                    <label for="mandat">Mandat</label>
                                    <textarea class="form-control" id="mandat" name="mandat" placeholder="Mandat...">
                                              {{ $about->mandat ? html_entity_decode($about->mandat) : old('mandat') }}
                                    </textarea>
                                    @error('mandat')
                                        <span class="small text-danger" role="alert">{{ $message }}</span>
                                    @enderror
                                </div>
                            </div>
                        </div>
                        <div class="row">
                            <div class="col-md-12">
                                <div class="form-group">
                                    <label for="goal">But</label>
                                    <textarea class="form-control" id="goal" name="goal" placeholder="BUT...">
                                              {{ $about->goal ? html_entity_decode($about->goal) : old('goal') }}
                                    </textarea>
                                    @error('goal')
                                        <span class="small text-danger" role="alert">{{ $message }}</span>
                                    @enderror
                                </div>
                            </div>
                        </div>
                        <div class="row">
                            <div class="col-md-12">
                                <div class="form-group">
                                    <label for="mission">Mission</label>
                                    <textarea class="form-control" id="mission" name="mission" rows="5" placeholder="Mission...">
                                              {{ $about->mission ? html_entity_decode($about->mission) : old('mission') }}
                                    </textarea>
                                    @error('mission')
                                        <span class="small text-danger" role="alert">{{ $message }}</span>
                                    @enderror
                                </div>
                            </div>
                        </div>

                        <div class="row">
                            <div class="col small text-danger">
                                Les champs * sont obligatoires
                            </div>
                        </div>
                    </div>
                    <div class="card-footer">
                        <button type="button" class="btn btn-danger" data-toggle="modal" data-target="#aboutDeleteModal">
                            <i class="fas fa-trash-alt"></i>
                        </button>
                        <button name="submit" type="submit" class="btn btn-primary float-right">
                            <i class="fas fa-save"></i>
                            Enregistrer
                        </button>
                    </div>
                </form>
            </div>
        </div>
        <div class="col-md-4">
            <div class="card mb-3">
                <div class="card-header card-outline card-primary">
                    <h3 class="card-title">
                        Image
                    </h3>
                </div>
                @if ($about->image)
                    <div class="card-body text-center p-0">
                        <img class="img-thumbnail w-100" src="{{ asset('storage/abouts/' . $about->image . '') }}"
                            alt="{{ $about->slug }}">
                    </div>
                    <div class="card-footer text-right">
                        <a href="{{ route('abouts.image.delete', $about) }}" class="btn btn-link">
                            <i class="fas fa-trash-alt text-danger"></i>
                        </a>
                    </div>
                @else
                    <form enctype="multipart/form-data" role="form" method="POST"
                        action="{{ route('abouts.image.store', $about) }}">
                        @csrf
                        <div class="card-body">
                            <div class="form-group">
                                <div class="input-group">
                                    <div class="custom-file">
                                        <input type="file" class="custom-file-input" id="image" name="image"
                                            accept="image/*">
                                        <label class="custom-file-label" for="image">Choisir image</label>
                                    </div>
                                </div>
                            </div>

                            <div class="row">
                                <div class="col small text-danger">
                                    Dimension image: 800 x 500 px
                                </div>
                            </div>

                        </div>
                        <div class="card-footer text-right">
                            <button name="submit" type="submit" class="btn btn-primary">
                                <i class="fas fa-save mr-2"></i>
                                Enregistrer
                            </button>
                        </div>
                    </form>
                @endif
            </div>
        </div>
    </div>

    <!-- DELETE ABOUT MODAL -->
    <!-- <form action="{{ route('abouts.destroy', $about) }}" method="POST">
                @method('delete')
                @csrf
                <div class="modal fade" id="aboutDeleteModal" tabindex="-1"
                        aria-labelledby="aboutDeleteModalLabel" aria-hidden="true">
                    <div class="modal-dialog">
                        <div class="modal-content">
                            <div class="modal-header">
                                <h5 class="modal-title" id="aboutDeleteModalLabel">Supprimer activité</h5>
                                <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                                    <span aria-hidden="true">&times;</span>
                                </button>
                            </div>
                            <div class="modal-body">
                                <input type="hidden" id="about_id" name="about_id">
                                <span>
                            Etes-vous sûr de vouloir supprimer cette activité?
                        </span>
                            </div>
                            <div class="modal-footer">
                                <button type="button" class="btn btn-secondary" data-dismiss="modal">annuler</button>
                                <button type="submit" class="btn btn-danger">Supprimer activité</button>
                            </div>
                        </div>
                    </div>
                </div>
            </form> -->
@endsection
@section('scripts')
    <script src="https://cdn.ckeditor.com/ckeditor5/23.0.0/classic/ckeditor.js"></script>
    <script src="{{ asset('theme/plugins/bs-custom-file-input/bs-custom-file-input.min.js') }}"></script>
    <script>
        $(function() {
            bsCustomFileInput.init();
        });
    </script>
    <script>
        ClassicEditor
            .create(document.querySelector('#mission'), {
                removePlugins: ['CKFinderUploadAdapter', 'CKFinder', 'EasyImage', 'Image', 'ImageCaption', 'ImageStyle',
                    'ImageToolbar', 'ImageUpload', 'MediaEmbed'
                ],
            })
            .catch(error => {
                console.error(error);
            });
        ClassicEditor
            .create(document.querySelector('#objective'), {
                removePlugins: ['CKFinderUploadAdapter', 'CKFinder', 'EasyImage', 'Image', 'ImageCaption', 'ImageStyle',
                    'ImageToolbar', 'ImageUpload', 'MediaEmbed'
                ],
            })
            .catch(error => {
                console.error(error);
            });
        ClassicEditor
            .create(document.querySelector('#goal'), {
                removePlugins: ['CKFinderUploadAdapter', 'CKFinder', 'EasyImage', 'Image', 'ImageCaption', 'ImageStyle',
                    'ImageToolbar', 'ImageUpload', 'MediaEmbed'
                ],
            })
            .catch(error => {
                console.error(error);
            });
        ClassicEditor
            .create(document.querySelector('#about_text'), {
                removePlugins: ['CKFinderUploadAdapter', 'CKFinder', 'EasyImage', 'Image', 'ImageCaption', 'ImageStyle',
                    'ImageToolbar', 'ImageUpload', 'MediaEmbed'
                ],
            })
            .catch(error => {
                console.error(error);
            });
        ClassicEditor
            .create(document.querySelector('#mandat'), {
                removePlugins: ['CKFinderUploadAdapter', 'CKFinder', 'EasyImage', 'Image', 'ImageCaption', 'ImageStyle',
                    'ImageToolbar', 'ImageUpload', 'MediaEmbed'
                ],
            })
            .catch(error => {
                console.error(error);
            });
    </script>
@endsection
