@extends('layouts.default', ['current' => 'activities'])
@section('page_title', 'Modifier activité')
@section('breadcrumb')
    <div class="content-header">
        <div class="container-fluid">
            <div class="row justify-content-end mb-2">
                <div class="col-sm-6">
                    <ol class="breadcrumb float-sm-right">
                        <li class="breadcrumb-item"><a href="{{ route('dashboard') }}">Dashboard</a></li>
                        <li class="breadcrumb-item"><a href="{{ route('activities.index') }}">activités</a></li>
                        <li class="breadcrumb-item active">Modifier activité</li>
                    </ol>
                </div>
            </div>
        </div>
    </div>
@endsection
@section('content')
    <div class="row">
        <div class="col-md-7 mb-3">
            <div class="card">
                <div class="card-header card-outline card-primary">
                    <h3 class="card-title">Informations générales</h3>
                </div>
                <form role="form" method="POST" action="{{ route('activities.update', $activity) }}">
                    @csrf
                    @method('PUT')
                    <div class="card-body">
                        <div class="row">
                            <div class="col-md-12">
                                <div class="form-group">
                                    <label for="name">Nom <span class="text-danger">*</span></label>
                                    <input type="text" name="name" class="form-control" id="name"
                                        value="{{ $activity->title ? $activity->title : old('name') }}"
                                        placeholder="Ex. Jus mango" required>
                                    @error('name')
                                        <span class="small text-danger" role="alert">{{ $message }}</span>
                                    @enderror
                                </div>
                            </div>
                        </div>
                        <div class="row">
                            <div class="col-sm-12">
                                <div class="form-group">
                                    <label>Début de l'activité <span class="text-danger">*</span></label>
                                    <div class="input-group">
                                        <div class="input-group-prepend">
                                            <span class="input-group-text"><i class="far fa-calendar-alt"></i></span>
                                        </div>
                                        <input type="date" name="start_date" id="start_date" class="form-control"
                                            placeholder="dd-mm-yyyy"
                                            value="{{ $activity->started_at ? $activity->started_at : old('start_date') }}"
                                            required>
                                        @error('start_date')
                                            <span class="small text-danger" role="alert">{{ $message }}</span>
                                        @enderror
                                    </div>
                                </div>
                            </div>
                        </div>
                        <div class="row">
                            <div class="col-sm-12">
                                <div class="form-group">
                                    <label>Description</label>
                                    <textarea name="description" id="description" class="form-control" rows="5"
                                        placeholder="Ajouter une brève description">{{ $activity->description ? html_entity_decode($activity->description) : old('description') }}</textarea>
                                    @error('description')
                                        <span class="small text-danger" role="alert">{{ $message }}</span>
                                    @enderror
                                </div>
                            </div>
                        </div>

                        <div class="row">
                            <div class="col small text-danger">
                                Les champs * sont obligatoires
                            </div>
                        </div>
                    </div>
                    <div class="card-footer">
                        <button type="button" class="btn btn-danger" data-toggle="modal"
                            data-target="#activityDeleteModal">
                            <i class="fas fa-trash-alt"></i>
                        </button>
                        <button name="submit" type="submit" class="btn btn-primary float-right">
                            <i class="fas fa-save"></i>
                            Enregistrer
                        </button>
                    </div>
                </form>
            </div>
        </div>

        <div class="col-md-5 mb-3">
            <div class="card">
                <div class="card-header card-outline card-primary">
                    <h3 class="card-title">Ajouter Image</h3>
                </div>
                <form enctype="multipart/form-data" role="form" method="POST"
                    action="{{ route('store.image', $activity) }}">
                    @csrf
                    <div class="card-body">
                        <div class="form-group">
                            <div class="input-group">
                                <div class="custom-file">
                                    <input type="file" class="custom-file-input" id="image" name="image"
                                        accept="image/*">
                                    <label class="custom-file-label" for="image">Choisir image</label>
                                </div>
                            </div>
                        </div>
                        <div class="row">
                            <div class="col small text-danger">
                                Dimension image: 733 x 500 px
                            </div>
                        </div>
                    </div>
                    <div class="card-footer text-right">
                        <button name="submit" type="submit" class="btn btn-primary">
                            <i class="fas fa-save mr-2"></i>
                            Enregistrer
                        </button>
                    </div>
                </form>
            </div>
            @if ($activity->images->isNotEmpty())
                <div class="card">
                    <div class="card-header card-outline card-primary">
                        <h3 class="card-title">Les images de l'activité</h3>
                    </div>
                    <div class="card-body table-responsive p-0">
                        <table class="table table-hover  table-sm text-nowrap">
                            <thead class="tbl-head bg-dark-light">
                                <tr>
                                    <th style="width: 5%;">#</th>
                                    <th style="min-width: 30%;">Image</th>
                                    <th style="width: 10%;"></th>
                                </tr>
                            </thead>
                            <tbody>

                                @forelse($activity->images as $image)
                                    <tr>
                                        <td>{{ $loop->iteration }}.</td>

                                        <td>
                                            <img class="mr-2"
                                                src="{{ asset('storage/activities/' . $image->image . '') }}"
                                                style="height: 60px; width: 60px; object-fit: cover; object-position: center"
                                                alt="{{ $image->slug }}">
                                        </td>
                                        <td class="d-flex justify-content-end">
                                            <a href="{{ route('delete.image', $image) }}">
                                                <i class="fas mr-2 fa-trash text-danger" title="Supprimer"></i>
                                            </a>
                                        </td>
                                    </tr>
                                @empty
                                    <tr>
                                        <td colspan="5" style="text-align: center;">Aucune Image enregistrée!</td>
                                    </tr>
                                @endforelse
                            </tbody>
                        </table>
                    </div>
                </div>
            @endif
        </div>
    </div>

    <!-- DELETE ACTIVITY MODAL -->
    <form action="{{ route('activities.destroy', $activity) }}" method="POST">
        @method('delete')
        @csrf
        <div class="modal fade" id="activityDeleteModal" tabindex="-1" aria-labelledby="activityDeleteModalLabel"
            aria-hidden="true">
            <div class="modal-dialog">
                <div class="modal-content">
                    <div class="modal-header">
                        <h5 class="modal-title" id="activityDeleteModalLabel">Supprimer activité</h5>
                        <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                            <span aria-hidden="true">&times;</span>
                        </button>
                    </div>
                    <div class="modal-body">
                        <input type="hidden" id="activity_id" name="activity_id">
                        <span>
                            Etes-vous sûr de vouloir supprimer cette activité?
                        </span>
                    </div>
                    <div class="modal-footer">
                        <button type="button" class="btn btn-secondary" data-dismiss="modal">annuler</button>
                        <button type="submit" class="btn btn-danger">Supprimer activité</button>
                    </div>
                </div>
            </div>
        </div>
    </form>
@endsection
@section('scripts')
    <script src="{{ asset('theme/plugins/bs-custom-file-input/bs-custom-file-input.min.js') }}"></script>
    <script>
        $(function() {
            bsCustomFileInput.init();
        });
    </script>
    @include('partials._ckeditor')
@endsection
