@extends('layouts.default', ['current' => 'activities'])
@section('page_title', 'Activités')
@section('breadcrumb')
    <div class="content-header">
        <div class="container-fluid">
            <div class="row justify-content-end mb-2">
                <div class="col-sm-6">
                    <ol class="breadcrumb float-sm-right">
                        <li class="breadcrumb-item"><a href="{{ route('dashboard') }}">Dashboard</a></li>
                        <li class="breadcrumb-item active">Activités</li>
                    </ol>
                </div>
            </div>
        </div>
    </div>
@endsection
@section('content')
    <div class="row">
        <div class="col-12">
            <div class="card">
                <div class="card-header">
                    <h2 class="card-title">Activités</h2>
                    <div class="card-tools">
                        <button type="button" class="btn btn-primary" data-toggle="modal"
                            data-target="#activityStoreModal">
                            <i class="fas fa-plus mr-2"></i>
                            Ajouter activité
                        </button>
                    </div>
                </div>
                <div class="card-header">
                    <div class="row justify-content-end">
                        <div class="col-md-2">
                            <div class="input-group input-group-sm">
                                <input type="text" name="table_search" class="form-control float-right"
                                    placeholder="Search">
                                <div class="input-group-append">
                                    <button type="submit" class="btn btn-default">
                                        <i class="fas fa-search"></i>
                                    </button>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="card-body table-responsive p-0">
                    <table class="table table-hover  table-sm text-nowrap">
                        <thead class="tbl-head bg-dark-light">
                            <tr>
                                <th style="width: 5%;">#</th>
                                <th style="min-width: 30%;">Titre</th>
                                <th>Début de l'activité</th>
                                <th style="width: 10%;"></th>
                            </tr>
                        </thead>
                        <tbody>
                            @if ($activities->isNotEmpty())
                                @forelse($activities as $activity)
                                    <tr>
                                        <td>{{ $loop->iteration }}.</td>
                                        <td>
                                            <a href="{{ route('activities.edit', ['activity' => $activity]) }}">
                                                <span>{{ $activity->title }}</span>
                                            </a>
                                        </td>
                                        <td>
                                            {{ Carbon\Carbon::parse($activity->started_at)->format('d-m-Y') }}
                                        </td>
                                        <td class="d-flex justify-content-end">
                                            <a href="{{ route('activities.edit', $activity) }}">
                                                <i class="fas mr-2 fa-edit text-warning" title="Modifier"></i>
                                            </a>
                                        </td>
                                    </tr>
                                @empty
                                    <tr>
                                        <td colspan="5" style="text-align: center;">Aucune activité enregistrée!</td>
                                    </tr>
                                @endforelse
                            @else
                                <tr>
                                    <td colspan="5" style="text-align: center;">Aucune activité enregistrée!</td>
                                </tr>
                            @endif
                        </tbody>
                    </table>
                </div>
                @if ($activities->hasPages())
                    <div class="card-footer clearfix">
                        <ul class="pagination pagination-sm m-0 float-right">
                            <li class="page-item">
                                <a class="btn btn-default btn-sm {{ $activities->onFirstPage() ? 'disabled' : null }}"
                                    href="{{ $activities->previousPageUrl() }}">&laquo;</a>
                            </li>
                            <li class="page-item">
                                <a href="{{ $activities->nextPageUrl() }}"
                                    class="btn btn-default btn-sm {{ !$activities->hasMorePages() ? 'disabled' : null }}">&raquo;</a>
                            </li>
                        </ul>
                    </div>
                @endif
            </div>
        </div>
    </div>

    {{--  ADD ACTIVITY MODAL --}}
    <form enctype="multipart/form-data" action="{{ route('activities.store') }}" method="POST">
        @csrf
        <div class="modal fade" id="activityStoreModal" tabindex="-1" aria-labelledby="activityStoreModalLabel"
            aria-hidden="true">
            <div class="modal-dialog">
                <div class="modal-content">
                    <div class="modal-header">
                        <h5 class="modal-title" id="activityStoreModalLabel">AJOUTER ACTIVITE</h5>
                        <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                            <span aria-hidden="true">&times;</span>
                        </button>
                    </div>
                    <div class="modal-body">
                        <div class="row">
                            <div class="col-md-12">
                                <div class="form-group">
                                    <label for="name">Titre de l'activité <span class="text-danger">*</span></label>
                                    <input type="text" name="name" class="form-control" id="name"
                                        value="{{ old('name') }}" placeholder="Ex. Analyse de données" required>
                                </div>
                            </div>
                        </div>
                        <div class="row">
                            <div class="col-sm-12">
                                <div class="form-group">
                                    <label>Date de l'activité <span class="text-danger">*</span></label>
                                    <div class="input-group">
                                        <div class="input-group-prepend">
                                            <span class="input-group-text"><i class="far fa-calendar-alt"></i></span>
                                        </div>
                                        <input type="date" name="start_date" id="start_date" class="form-control"
                                            placeholder="dd-mm-yyyy" value="{{ old('start_date') }}" required>
                                        @error('start_date')
                                            <span class="small text-danger" role="alert">{{ $message }}</span>
                                        @enderror
                                    </div>
                                </div>
                            </div>
                        </div>
                        <div class="row">
                            <div class="col-md-12">
                                <div class="form-group">
                                    <label for="description">Description</label>
                                    <textarea class="form-control" id="description" name="description"
                                        placeholder="Faîtes une description détaillée de l' activité" style="width: 100%; height: 200px;"></textarea>
                                </div>
                            </div>
                        </div>
                        <div class="modal-footer">
                            <button type="button" class="btn btn-secondary" data-dismiss="modal">Annuler</button>
                            <button type="submit" class="btn btn-primary">
                                <i class="fas fa-save mr-2"></i>
                                Enregistrer
                            </button>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </form>

@endsection
@section('scripts')
    @include('partials._ckeditor')
    <script src="{{ asset('theme/plugins/bs-custom-file-input/bs-custom-file-input.min.js') }}"></script>
    <script>
        $(function() {
            bsCustomFileInput.init();
        });
    </script>
    <script type="text/javascript">
        function readURL(input) {
            if (input.files && input.files[0]) {
                var reader = new FileReader();

                reader.onload = function(e) {
                    $('#activity_img').attr('src', e.target.result);
                }

                reader.readAsDataURL(input.files[0]);
            }
        }

        $("#image").change(function() {
            readURL(this);
        });
    </script>
@endsection
