@extends('layouts.login')
@section('page_title')
{{ strtoupper(config('app.name')) }} | Forgot-password
@endsection
@section('content')
    @include('partials._alerts')
    <div class="card-body">
        <div class="mb-4 text-sm text-gray-600 text-center">
            Vous avez oublié votre mot de passe? Aucun problème. Faites-nous simplement savoir votre adresse e-mail et nous vous enverrons par e-mail un lien de réinitialisation de mot de passe qui vous permettra d’en créer un nouveau.
        </div>
        <form method="POST" action="{{ route('password.email') }}">
            @csrf
            <div class="input-group mb-3">
                <input name="email" id="email" type="email" value="{{old('email')}}" class="form-control" placeholder="Email" autofocus required>
                <div class="input-group-append">
                    <div class="input-group-text">
                        <span class="fas fa-envelope"></span>
                    </div>
                </div>
            </div>
            <div class="row">
                <div class="col-12">
                    <button type="submit" class="btn btn-primary btn-block">
                        Envoyer lien de réinitialisation
                    </button>
                </div>
            </div>
        </form>
        <p class="mt-3 mb-1">
            <a href="{{route('login')}}">
                <span class="fas fa-arrow-left mr-2"></span>
                Se connecter
            </a>
        </p>
    </div>
@endsection
