@extends('layouts.login')
@section('page_title')
{{ strtoupper(config('app.name')) }} | Se connecter
@endsection
@section('content')
    <div class="cover-container d-flex w-100 h-100 p-3 mx-auto flex-column">
        <div class="card-body">
            <h4 class="login-box-msg"><b>Se connecter</b></h4>

            <form method="POST" action="{{ route('login') }}">
                @csrf
                <div class="input-group mb-3">
                    <input name="email" type="email" id="email" class="form-control" value="{{ old('email') }}"
                           placeholder="Email" required autofocus>
                    <div class="input-group-append">
                        <div class="input-group-text">
                            <span class="fas fa-envelope"></span>
                        </div>
                    </div>
                </div>
                <div class="input-group mb-3">
                    <input name="password" id="password" type="password" class="form-control" placeholder="Mot de passe"
                           required autocomplete="current-password">
                    <div class="input-group-append">
                        <div class="input-group-text">
                            <span class="fas fa-lock"></span>
                        </div>
                    </div>
                </div>
                <div class="row">
                    <div class="col-12 mb-3">
                        <button type="submit" class="btn btn-primary btn-block">Se connecter</button>
                    </div>
                </div>
            </form>
            <p class="mb-1">
                @if (Route::has('password.request'))
                    <a class="underline text-sm text-gray-600 hover:text-gray-900"
                       href="{{ route('password.request') }}">Mot de passe oublié</a>
                @endif
            </p>
        </div>
    </div>
@endsection

