@extends('layouts.default', ['current' => 'contacts'])
@section('page_title', 'Modifier Contact')
@section('breadcrumb')
    <div class="content-header">
        <div class="container-fluid">
            <div class="row justify-content-end mb-2">
                <div class="col-sm-6">
                    <ol class="breadcrumb float-sm-right">
                        <li class="breadcrumb-item"><a href="{{ route('dashboard') }}">Dashboard</a></li>
                        <li class="breadcrumb-item"><a href="{{ route('contacts.index') }}">contacts</a></li>
                        <li class="breadcrumb-item active">Modifier contact</li>
                    </ol>
                </div>
            </div>
        </div>
    </div>
@endsection
@section('content')
    <div class="row">
        <div class="col-md-8 mb-3">
            <div class="card">
                <div class="card-header card-outline card-primary">
                    <h3 class="card-title">Informations générales</h3>
                </div>
                <form role="form" method="POST" action="{{ route('contacts.update', $contact) }}">
                    @csrf
                    @method('PUT')
                    <div class="card-body">
                        <div class="row">
                            <div class="col-md-6">
                                <div class="form-group">
                                    <label for="phone">Téléphone <span class="text-danger">*</span></label>
                                    <input type="tel" name="telephone" class="form-control" id="telephone"
                                        value="{{ $contact->telephone ? $contact->telephone : old('telephone') }}"
                                        placeholder="Ex. +243 999-999-999" required>
                                    @error('telephone')
                                        <span class="small text-danger" role="alert">{{ $message }}</span>
                                    @enderror
                                </div>
                            </div>
                            <div class="col-md-6">
                                <div class="form-group">
                                    <label for="email">Email <span class="text-danger">*</span></label>
                                    <input type="email" name="email" class="form-control" id="email"
                                        value="{{ $contact->email ? $contact->email : old('email') }}"
                                        placeholder="Ex. ubs@gmail.com" required>
                                    @error('email')
                                        <span class="small text-danger" role="alert">{{ $message }}</span>
                                    @enderror
                                </div>
                            </div>
                        </div>
                        <div class="row">
                            <div class="col-md-6">
                                <div class="form-group">
                                    <label for="facebook">Facebook <span class="text-danger">*</span></label>
                                    <input type="tel" name="facebook" class="form-control" id="facebook"
                                        value="{{ $contact->facebook ? $contact->facebook : old('facebook') }}"
                                        placeholder="Facebook url">
                                    @error('facebook')
                                        <span class="small text-danger" role="alert">{{ $message }}</span>
                                    @enderror
                                </div>
                            </div>
                            <div class="col-md-6">
                                <div class="form-group">
                                    <label for="instagram">Instagram <span class="text-danger">*</span></label>
                                    <input type="text" name="instagram" class="form-control" id="instagram"
                                        value="{{ $contact->instagram ? $contact->instagram : old('instagram') }}"
                                        placeholder="Instagram url">
                                    @error('instagram')
                                        <span class="small text-danger" role="alert">{{ $message }}</span>
                                    @enderror
                                </div>
                            </div>
                            <div class="col-md-6">
                                <div class="form-group">
                                    <label for="twitter">Twitter <span class="text-danger">*</span></label>
                                    <input type="text" name="twitter" class="form-control" id="twitter"
                                        value="{{ $contact->twitter ? $contact->twitter : old('twitter') }}"
                                        placeholder="Twitter url">
                                    @error('twitter')
                                        <span class="small text-danger" role="alert">{{ $message }}</span>
                                    @enderror
                                </div>
                            </div>
                            <div class="col-md-6">
                                <div class="form-group">
                                    <label for="tiktok">TikTok <span class="text-danger">*</span></label>
                                    <input type="text" name="tiktok" class="form-control" id="tiktok"
                                        value="{{ $contact->tiktok ? $contact->tiktok : old('tiktok') }}"
                                        placeholder="tiktok url">
                                    @error('tiktok')
                                        <span class="small text-danger" role="alert">{{ $message }}</span>
                                    @enderror
                                </div>
                            </div>
                        </div>
                        <div class="row">
                            <div class="col-md-12">
                                <div class="form-group">
                                    <label>Adresse <span class="text-danger">*</span></label>
                                    <textarea name="address" id="address" class="form-control" rows="2"
                                        placeholder="Ajouter une brève description">{{ $contact->address ? $contact->address : old('address') }}</textarea>
                                    @error('address')
                                        <span class="small text-danger" role="alert">{{ $message }}</span>
                                    @enderror
                                </div>
                            </div>
                        </div>
                        <div class="row">
                            <div class="col small text-danger">
                                Les champs * sont obligatoires
                            </div>
                        </div>
                    </div>
                    <div class="card-footer">
                        @if ($contacts->count() > 1)
                            <button type="button" class="btn btn-danger" data-toggle="modal"
                                data-target="#contactDeleteModal">
                                <i class="fas fa-trash-alt"></i>
                            </button>
                        @endif
                        <button name="submit" type="submit" class="btn btn-primary float-right">
                            <i class="fas fa-save"></i>
                            Enregistrer
                        </button>
                    </div>
                </form>
            </div>
        </div>

        <!-- DELETE CONTACT MODAL -->
        <form action="{{ route('contacts.destroy', $contact) }}" method="POST">
            @method('delete')
            @csrf
            <div class="modal fade" id="contactDeleteModal" tabindex="-1" aria-labelledby="contactDeleteModalLabel"
                aria-hidden="true">
                <div class="modal-dialog">
                    <div class="modal-content">
                        <div class="modal-header">
                            <h5 class="modal-title" id="contactDeleteModalLabel">Supprimer contact</h5>
                            <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                                <span aria-hidden="true">&times;</span>
                            </button>
                        </div>
                        <div class="modal-body">
                            <input type="hidden" id="contact_id" name="contact_id">
                            <span>
                                Etes-vous sûr de vouloir supprimer ce contact?
                            </span>
                        </div>
                        <div class="modal-footer">
                            <button type="button" class="btn btn-secondary" data-dismiss="modal">annuler</button>
                            <button type="submit" class="btn btn-danger">Supprimer contact</button>
                        </div>
                    </div>
                </div>
            </div>
        </form>
    @endsection
