@extends('layouts.default', ['current' => 'contacts'])
@section('page_title', 'Contacts')
@section('breadcrumb')
    <div class="content-header">
        <div class="container-fluid">
            <div class="row justify-content-end mb-2">
                <div class="col-sm-6">
                    <ol class="breadcrumb float-sm-right">
                        <li class="breadcrumb-item"><a href="{{ route('dashboard') }}">Dashboard</a></li>
                        <li class="breadcrumb-item active">Contacts</li>
                    </ol>
                </div>
            </div>
        </div>
    </div>
@endsection
@section('content')
    <div class="row">
        <div class="col-12">
            <div class="card">
                <div class="card-header">
                    <h2 class="card-title">CONTACTS</h2>
                    @if ($contacts->count() < 1)
                        <div class="card-tools">
                            <button type="button" class="btn btn-primary" data-toggle="modal"
                                data-target="#contactStoreModal">
                                <i class="fas fa-plus mr-2"></i>
                                Ajouter contact
                            </button>
                        </div>
                    @endif
                </div>
                <div class="card-header">
                    <div class="row justify-content-end">
                        <div class="col-md-2">
                            <div class="input-group input-group-sm">
                                <input type="text" name="table_search" class="form-control float-right"
                                    placeholder="Search">
                                <div class="input-group-append">
                                    <button type="submit" class="btn btn-default">
                                        <i class="fas fa-search"></i>
                                    </button>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="card-body table-responsive p-0">
                    <table class="table table-hover  table-sm text-nowrap">
                        <thead class="tbl-head bg-dark-light">
                            <tr>
                                <th style="width: 5%;">#</th>
                                <th style="min-width: 30%;">Réference</th>
                                <th style="min-width: 30%;">Téléphone</th>
                                <th style="min-width: 30%;">Email</th>
                                <th style="width: 10%;"></th>
                            </tr>
                        </thead>
                        <tbody>
                            @if ($contacts->isNotEmpty())
                                @forelse($contacts as $contact)
                                    <tr>
                                        <td>{{ $loop->iteration }}.</td>
                                        <td>
                                            <a href="{{ route('contacts.edit', ['contact' => $contact]) }}">
                                                <span>{{ $contact->reference }}</span>
                                            </a>
                                        </td>
                                        <td>
                                            {{ $contact->telephone }}
                                        </td>
                                        <td>
                                            {{ $contact->email }}
                                        </td>
                                        <td class="d-flex justify-content-end">
                                            <a href="{{ route('contacts.edit', $contact) }}">
                                                <i class="fas mr-2 fa-edit text-warning" title="Modifier"></i>
                                            </a>
                                        </td>
                                    </tr>
                                @empty
                                    <tr>
                                        <td colspan="5" style="text-align: center;">Aucun contact enregistré!</td>
                                    </tr>
                                @endforelse
                            @else
                                <tr>
                                    <td colspan="5" style="text-align: center;">Aucun contact enregistré!</td>
                                </tr>
                            @endif
                        </tbody>
                    </table>
                </div>
                @if ($contacts->hasPages())
                    <div class="card-footer clearfix">
                        <ul class="pagination pagination-sm m-0 float-right">
                            <li class="page-item">
                                <a class="btn btn-default btn-sm {{ $contacts->onFirstPage() ? 'disabled' : null }}"
                                    href="{{ $contacts->previousPageUrl() }}">&laquo;</a>
                            </li>
                            <li class="page-item">
                                <a href="{{ $contacts->nextPageUrl() }}"
                                    class="btn btn-default btn-sm {{ !$contacts->hasMorePages() ? 'disabled' : null }}">&raquo;</a>
                            </li>
                        </ul>
                    </div>
                @endif
            </div>
        </div>
    </div>

    {{--  ADD CONTACT MODAL --}}
    <form role="form" action="{{ route('contacts.store') }}" method="POST">
        @csrf
        <div class="modal fade" id="contactStoreModal" tabindex="-1" aria-labelledby="contactStoreModalLabel"
            aria-hidden="true">
            <div class="modal-dialog">
                <div class="modal-content">
                    <div class="modal-header">
                        <h5 class="modal-title" id="contactStoreModalLabel">AJOUTER CONTACT</h5>
                        <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                            <span aria-hidden="true">&times;</span>
                        </button>
                    </div>
                    <div class="modal-body">
                        <div class="row">
                            <div class="col-md-6">
                                <div class="form-group">
                                    <label for="telephone">Téléphone <span class="text-danger">*</span></label>
                                    <input type="tel" name="telephone" class="form-control" id="telephone"
                                        value="{{ old('telephone') }}" placeholder="Ex. +243 999-999-999" required>
                                    @error('telephone')
                                        <span class="small text-danger" role="alert">{{ $message }}</span>
                                    @enderror
                                </div>
                            </div>
                            <div class="col-md-6">
                                <div class="form-group">
                                    <label for="email">Email <span class="text-danger">*</span></label>
                                    <input type="email" name="email" class="form-control" id="email"
                                        value="{{ old('email') }}" placeholder="Ex. mobutu@gmail.com" required>
                                    @error('email')
                                        <span class="small text-danger" role="alert">{{ $message }}</span>
                                    @enderror
                                </div>
                            </div>
                        </div>
                        <div class="row">
                            <div class="col-md-6">
                                <div class="form-group">
                                    <label for="facebook">Facebook <span class="text-danger">*</span></label>
                                    <input type="tel" name="facebook" class="form-control" id="facebook"
                                        value="{{ old('facebook') }}" placeholder="Facebook url">
                                    @error('facebook')
                                        <span class="small text-danger" role="alert">{{ $message }}</span>
                                    @enderror
                                </div>
                            </div>
                            <div class="col-md-6">
                                <div class="form-group">
                                    <label for="instagram">Instagram <span class="text-danger">*</span></label>
                                    <input type="text" name="instagram" class="form-control" id="instagram"
                                        value="{{ old('instagram') }}" placeholder="Instagram url">
                                    @error('instagram')
                                        <span class="small text-danger" role="alert">{{ $message }}</span>
                                    @enderror
                                </div>
                            </div>
                            <div class="col-md-6">
                                <div class="form-group">
                                    <label for="twitter">Twitter <span class="text-danger">*</span></label>
                                    <input type="text" name="twitter" class="form-control" id="twitter"
                                        value="{{ old('twitter') }}" placeholder="Twitter url">
                                    @error('twitter')
                                        <span class="small text-danger" role="alert">{{ $message }}</span>
                                    @enderror
                                </div>
                            </div>
                            <div class="col-md-6">
                                <div class="form-group">
                                    <label for="tiktok">TikTok <span class="text-danger">*</span></label>
                                    <input type="text" name="tiktok" class="form-control" id="tiktok"
                                        value="{{ old('tiktok') }}" placeholder="tiktok url">
                                    @error('tiktok')
                                        <span class="small text-danger" role="alert">{{ $message }}</span>
                                    @enderror
                                </div>
                            </div>
                        </div>
                        <div class="row">
                            <div class="col-md-12">
                                <div class="form-group">
                                    <label>Adresse <span class="text-danger">*</span></label>
                                    <textarea name="address" id="address" class="form-control" rows="2"
                                        placeholder="Ex. Av.Bunia, Q.MURARA, GOMA, DRC">{{ old('address') }}</textarea>
                                    @error('address')
                                        <span class="small text-danger" role="alert">{{ $message }}</span>
                                    @enderror
                                </div>
                            </div>
                        </div>
                        <div class="modal-footer">
                            <button type="button" class="btn btn-secondary" data-dismiss="modal">Annuler</button>
                            <button type="submit" class="btn btn-primary">
                                <i class="fas fa-save mr-2"></i>
                                Enregistrer
                            </button>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </form>
@endsection
