@extends('layouts.default', ['current' => 'dashboard'])
@section("page_title", "Dashboard")
@section('breadcrumb')
<div class="content-header">
    <div class="container-fluid">
        <div class="row justify-content-end mb-2">
            <div class="col-sm-6">
                <ol class="breadcrumb float-sm-right">
                    <li class="breadcrumb-item active">Dashboard</li>
                </ol>
            </div>
        </div>
    </div>
</div>
@endsection
@section("content")
<div class="row">
    <div class="col-12 col-sm-6 col-md-3">
        <div class="info-box">
            <span class="info-box-icon elevation-1">
                <img type="image/png" style="width: 48px" src="{{asset('img/icons/icons8-students-64.png')}}">
            </span>
            <div class="info-box-content">
                <span class="info-box-text">Team Members</span>
                <span class="info-box-number">
                   {{ $teams }}
                </span>
            </div>
        </div>
    </div>

    <div class="col-12 col-sm-6 col-md-3">
        <div class="info-box mb-3">
            <span class="info-box-icon elevation-1">
                <img type="image/png" style="width: 48px" src="{{asset('img/icons/icons8-services-64.png')}}">
            </span>
            <div class="info-box-content">
                <span class="info-box-text">Activités</span>
                <span class="info-box-number">{{ $activities}}</span>
            </div>
        </div>
    </div>

    <div class="clearfix hidden-md-up"></div>
    <div class="col-12 col-sm-6 col-md-3">
        <div class="info-box mb-3">
            <span class="info-box-icon elevation-1">
                <img type="image/png" style="width: 48px" src="{{asset('img/icons/icons8-software-installer-48.png')}}">
            </span>
            <div class="info-box-content">
                <span class="info-box-text">Abonnés</span>
                <span class="info-box-number">{{ $subscribed }}</span>
            </div>
        </div>
    </div>
    <div class="col-12 col-sm-6 col-md-3">
        <div class="info-box mb-3">
            <span class="info-box-icon elevation-1">
                <img type="image/png" style="width: 48px" src="{{asset('img/icons/trainer.png')}}">
            </span>
            <div class="info-box-content">
                <span class="info-box-text">Désabonnés</span>
                <span class="info-box-number">
                    {{ $unsubscribed }}
                </span>
            </div>
        </div>
    </div>
    <div class="col-12 col-sm-6 col-md-3">
        <div class="info-box mb-3">
            <span class="info-box-icon elevation-1">
                <img type="image/png" style="width: 48px" src="{{asset('img/icons/icons8-training-48.png')}}">
            </span>
            <div class="info-box-content">
                <span class="info-box-text">Témoignages</span>
                <span class="info-box-number">
                    {{ $testimonies}}
                </span>
            </div>
        </div>
    </div>
</div>
@endsection




