@extends('frontend.layouts.app', ['current' => 'about'])
@section('page_title', 'A Propos')

@section('content')
    <section class="ftco-section contact-section ftco-no-pb" id="contact-section">
        <div class="container">
            <div class="row justify-content-center pb-5">
                <div class="col-md-12 heading-section text-center ftco-animate">
                    <span class="subheading">A propos de nous</span>
                    <h2 class="mb-4">Qui Nous Sommes</h2>
                </div>
            </div>
            <div class="row pb-5">
                <div class="col-md-6 ftco-animate">
                    <h2 class="mb-4">Peter Byamungu Ministries</h2>
                    <p>{!! $about->about_text !!}</p>
                </div>
                <div class="col-md-6 ftco-animate">
                    <img class="img-fluid" src="{{ asset('storage/abouts/' . $about->image . '') }}"
                        alt="{{ $about->slug }}" style="width: 100%; height: 100%; object-fit: contain;">
                </div>
            </div>
        </div>
    </section>

    @if ($teams->isNotEmpty())
        <section class="ftco-no-pb" id="pastor-section">
            <div class="container">
                <div class="row justify-content-center pb-5">
                    <div class="col-md-6 heading-section text-center ftco-animate">
                        <span class="subheading">Notre Equipe</span>
                        <h2 class="mb-4">Notre Equipe</h2>
                    </div>
                </div>
                <div class="row">
                    @foreach ($teams as $team)
                        <div class="col-md-6 col-lg-3 ftco-animate">
                            <div class="staff">
                                <div class="img-wrap d-flex align-items-stretch">
                                    <div class="img align-self-stretch"
                                        style="background-image: url({{ asset('storage/teams/' . $team->image . '') }});">
                                    </div>
                                </div>
                                <div class="text d-flex align-items-center pt-3 text-center">
                                    <div>
                                        <h3 class="mb-2">{{ $team->name }}</h3>
                                        <span class="position mb-4">{{ $team->title }}</span>
                                        {{-- <div class="faded">
                                            <ul class="ftco-social text-center">
                                                <li class="ftco-animate"><a href="#"><span
                                                            class="icon-twitter"></span></a>
                                                </li>
                                                <li class="ftco-animate"><a href="#"><span
                                                            class="icon-facebook"></span></a></li>
                                                <li class="ftco-animate"><a href="#"><span
                                                            class="icon-google-plus"></span></a></li>
                                                <li class="ftco-animate"><a href="#"><span
                                                            class="icon-instagram"></span></a></li>
                                            </ul>
                                        </div> --}}
                                        <p>{!! $team->description !!}</p>
                                    </div>
                                </div>
                            </div>
                        </div>
                    @endforeach
                </div>
            </div>
        </section>
    @endif
@endsection
