@extends('frontend.layouts.app', ['current' => 'activities'])
@section('page_title', 'Activités')

@section('content')
    @if ($activities->isNotEmpty())
        <section class="ftco-section bg-light" id="sermons-section">
            <div class="container">
                <div class="row justify-content-center pb-5">
                    <div class="col-md-12 heading-section text-center ftco-animate">
                        <span class="subheading">Activités</span>
                        <h2 class="mb-4">Nos Activités</h2>
                    </div>
                </div>
                <div class="row">
                    @foreach ($activities as $activity)
                        <div class="col-md-4">
                            <div class="sermon-wrap ftco-animate">
                                <div class="img d-flex align-items-center justify-content-center"
                                    style="background-image: url({{ $activity->images->isNotEmpty() ? asset('storage/activities/' . $activity->images->first()->image . '') : asset('front_theme/images/image_1.jpg') }});width:349px;height:450px;">
                                    <div class="text-content p-4 text-center">
                                        <p class="">
                                            <a href="{{ route('activity.show', $activity) }}"
                                                class="btn-custom p-2 text-center">
                                                Lire plus</a>
                                        </p>
                                    </div>
                                </div>
                                <div class="text pt-3 text-center">
                                    <h2 class="mb-0"><a
                                            href="{{ route('activity.show', $activity) }}">{{ $activity->title }}</a>
                                    </h2>
                                    <div class="meta">
                                        <p class="mb-0">
                                            <span>{{ Carbon\Carbon::parse($activity->started_at)->format('d-M-Y') }}</span>
                                        </p>
                                    </div>
                                </div>
                            </div>
                        </div>
                    @endforeach
                </div>
            </div>
        </section>
    @endif
@endsection
