@extends('frontend.layouts.app', ['current' => 'activities'])
@section('page_title', 'Activités')

@section('content')


    {{-- <section  class="ftco-section contact-section ftco-no-pb" id="contact-section">
        @foreach ($activity->images as $activity_image)
            <div class="slider-item js-fullheight"
                style="background-image:url({{ $activity_image ? asset('storage/activities/' . $activity_image->image . '') : asset('front_theme/images/image_1.jpg') }});">
                <div class="overlay"></div>
                <div class="container">
                    <div class="row no-gutters slider-text js-fullheight align-items-center justify-content-center"
                        data-scrollax-parent="true">
                        <div class="col-md-8 text-center ftco-animate mt-5">
                            <div class="text">
                                <div class="subheading">
                                    <span>activité</span>
                                </div>
                                <h1 class="mb-4">{{ $activity->title }}</h1>
                                <p>le {{ Carbon\Carbon::parse($activity->started_at)->format('d-M-Y') }}</p>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        @endforeach
    </section> --}}
    <section class="ftco-section contact-section">
        <div class="container">

            <div class="row">
                <div class="col-lg-8 ftco-animate">
                    <div class="container home-slider js-fullheight owl-carousel">
                        @foreach ($activity->images as $act_image)
                            <div class="slider-item js-fullheight"
                                style="background-image:url({{ $act_image ? asset('storage/activities/' . $act_image->image . '') : asset('front_theme/images/image_1.jpg') }});">
                                <div class="overlay"></div>
                                <div class="container">
                                    <div class="row no-gutters slider-text js-fullheight align-items-center justify-content-center"
                                        data-scrollax-parent="true">
                                        <div class="col-md-8 text-center ftco-animate mt-5">
                                            <div class="text">
                                                <div class="subheading">
                                                    <span>Activité</span>
                                                </div>
                                                <h1 class="mb-4">{{ $activity->title }}</h1>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        @endforeach
                    </div>
                    <p>{!! $activity->description !!}</p>
                </div>

                <div class="col-lg-4 sidebar ftco-animate">

                    <div class="sidebar-box ftco-animate">
                        <h3 class="heading-sidebar">Autres Activités</h3>
                        @foreach ($activities as $act)
                            <div class="block-21 mb-4 d-flex">
                                <a class="blog-img mr-4"
                                    style="background-image: url({{ $act->images->isNotEmpty() ? asset('storage/activities/' . $act->images->first()->image . '') : asset('front_theme/images/image_1.jpg') }});"></a>
                                <div class="text">
                                    <h3 class="heading"><a href="{{ route('activity.show', $act) }}">{{ $act->title }}</a>
                                    </h3>
                                    <div class="meta">
                                        <div><a href="#"><span class="icon-calendar"></span>
                                                {{ Carbon\Carbon::parse($activity->started_at)->format('d-M-Y') }}</a></div>

                                    </div>
                                </div>
                                <a href="{{ route('front.activities') }}">Toutes les activités</a>
                            </div>
                        @endforeach
                    </div>

                </div>
            </div>
        </div>
    </section>

@endsection

@section('addCSS')
    <style>
        /*owl carousel*/
        .owl-carousel .owl-stage,
        .owl-carousel.owl-drag .owl-item {
            -ms-touch-action: pan-y !important;
            touch-action: pan-y !important;
        }
    </style>
@endsection
