@extends('frontend.layouts.app', ['current' => 'contact'])
@section('page_title', 'Contact')

@section('content')
    <section class="ftco-section contact-section ftco-no-pb" id="contact-section">
        <div class="container">
            <div class="row justify-content-center mb-5 pb-3">
                <div class="col-md-7 heading-section text-center ftco-animate">
                    <span class="subheading">Contactez nous</span>
                    <h2 class="mb-4">Laissez Nous un Message</h2>
                    <p>Pour plus de renseignement, veuillez nous ecrire en remplissant ce formulaire.</p>
                </div>
            </div>
            <div class="row block-9">
                <div class="col-md-7 order-md-last d-flex">
                    <form action="{{ route('send.mail') }}" method="post" class="bg-light p-4 p-md-5 contact-form">
                        @csrf
                        @honeypot
                        <div class="form-group">
                            <input type="text" name="name" class="@error('name') is-invalid @enderror form-control"
                                placeholder="Votre Nom" value='{{ old('name') }}'>
                            @error('name')
                                <div class="alert alert-danger">{{ $message }}</div>
                            @enderror
                        </div>
                        <div class="form-group">
                            <input type="text" name="email" class="@error('email') is-invalid @enderror form-control"
                                placeholder="Votre Email" value='{{ old('email') }}'>
                            @error('email')
                                <div class="alert alert-danger">{{ $message }}</div>
                            @enderror

                        </div>
                        <div class="form-group">
                            <input type="text" name="subject" class="@error('subject') is-invalid @enderror form-control"
                                placeholder="Objet" value='{{ old('subject') }}'>
                            @error('subject')
                                <div class="alert alert-danger">{{ $message }}</div>
                            @enderror

                        </div>
                        <div class="form-group">
                            <textarea name="message" id="" cols="30" rows="7"
                                class="@error('Message') is-invalid @enderror form-control" placeholder="Message">{{ old('message') }}</textarea>
                            @error('message')
                                <div class="alert alert-danger">{{ $message }}</div>
                            @enderror

                        </div>
                        <div class="form-group">
                            <input type="submit" value="Send Message" class="btn btn-primary py-3 px-5">
                        </div>
                    </form>
                </div>
                <div class="col-md-5 d-flex">
                    <div class="row d-flex contact-info mb-5">
                        <div class="col-md-12 ftco-animate">
                            <div class="box p-2 px-3 bg-light d-flex">
                                <div class="icon mr-3">
                                    <span class="icon-map-signs"></span>
                                </div>
                                <div>
                                    <h3 class="mb-3">Adresse</h3>
                                    <p>{{ $contact->address }}</p>
                                </div>
                            </div>
                        </div>
                        <div class="col-md-12 ftco-animate">
                            <div class="box p-2 px-3 bg-light d-flex">
                                <div class="icon mr-3">
                                    <span class="icon-phone2"></span>
                                </div>
                                <div>
                                    <h3 class="mb-3">Téléphone</h3>
                                    <p><a href="tel:{{ $contact->telephone }}">{{ $contact->telephone }}</a></p>
                                </div>
                            </div>
                        </div>
                        <div class="col-md-12 ftco-animate">
                            <div class="box p-2 px-3 bg-light d-flex">
                                <div class="icon mr-3">
                                    <span class="icon-paper-plane"></span>
                                </div>
                                <div>
                                    <h3 class="mb-3">Adresse Email</h3>
                                    <p>{{ $contact->email }}</p>
                                </div>
                            </div>
                        </div>
                        <div class="col-md-12 ftco-animate">
                            <div class="box p-2 px-3 bg-light d-flex">
                                <div class="icon mr-3">
                                    <span class="icon-globe"></span>
                                </div>
                                <div>
                                    <h3 class="mb-3">Site Web</h3>
                                    <p><a href="#">{{ config('app.url') }}</a></p>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </section>
    <section class="ftco-section ftco-no-pt ftco-no-pb">
        <iframe
            src="https://www.google.com/maps/embed?pb=!1m14!1m12!1m3!1d31904.794353318983!2d29.210135799999996!3d-1.6819686999999999!2m3!1f0!2f0!3f0!3m2!1i1024!2i768!4f13.1!5e0!3m2!1sen!2scd!4v1671792535842!5m2!1sen!2scd"
            width="100%" height="500" style="border:0;" allowfullscreen="" loading="lazy"
            referrerpolicy="no-referrer-when-downgrade"></iframe>
    </section>
@endsection
