    <footer class="ftco-footer ftco-bg-dark ftco-section">
        <div class="container">
            <div class="row mb-5">
                <div class="col-md">
                    <div class="ftco-footer-widget mb-4">
                        <h2 class="ftco-heading-1 logo">A Propos</h2>
                        <p>{!! Str::limit(getAbout()->mission, 120) !!}</p>
                        <ul class="ftco-footer-social list-unstyled float-md-left float-lft mt-5">
                            @if (getContact()->twitter)
                                <li class="ftco-animate"><a href="{{ getContact()->twitter }}" target="__blank"><span
                                            class="icon-twitter"></span></a></li>
                            @endif
                            @if (getContact()->facebook)
                                <li class="ftco-animate"><a href="{{ getContact()->facebook }}" target="__blank"><span
                                            class="icon-facebook"></span></a></li>
                            @endif
                            @if (getContact()->instagram)
                                <li class="ftco-animate"><a href="{{ getContact()->instagram }}" target="__blank"><span
                                            class="icon-instagram"></span></a></li>
                            @endif
                            @if (getContact()->tiktok)
                                <li class="ftco-animate"><a href="{{ getContact()->tiktok }}" target="__blank">
                                        <span class="fab fa-tiktok"></span>
                                    </a>
                                </li>
                            @endif
                        </ul>
                    </div>
                </div>
                <div class="col-md">
                    <div class="ftco-footer-widget mb-4 ml-md-5">
                        <h2 class="ftco-heading-2">Liens Rapide</h2>
                        <ul class="list-unstyled">
                            <li><a href="{{ route('about') }}" class="py-1 d-block"><span
                                        class="ion-ios-arrow-forward mr-3"></span>A Propos</a></li>
                            <li><a href="{{ route('front.activities') }}" class="py-1 d-block"><span
                                        class="ion-ios-arrow-forward mr-3"></span>Activités</a></li>
                            <li><a href="{{ route('contact') }}" class="py-1 d-block"><span
                                        class="ion-ios-arrow-forward mr-3"></span>Contacts</a></li>
                        </ul>
                    </div>
                </div>
                <div class="col-md">
                    <div class="ftco-footer-widget mb-4 ml-md-5">
                        <h2 class="ftco-heading-2">Activités Récentes</h2>
                        <ul class="list-unstyled">
                            @forelse(getActivities() as $activity)
                                <li><a href="{{ route('activity.show', $activity) }}" class="py-1 d-block"><span
                                            class="ion-ios-arrow-forward mr-3"></span>{{ $activity->title }}</a></li>
                            @empty
                                <li><a href="#" class="py-1 d-block"><span
                                            class="ion-ios-arrow-forward mr-3"></span>Pas d'activités récentes</a></li>
                            @endforelse

                        </ul>
                    </div>
                </div>
                <div class="col-md">
                    <div class="ftco-footer-widget mb-4">
                        <h2 class="ftco-heading-2">Abonnez-vous</h2>
                        <div class="opening-hours">
                            <form action="{{ route('subscribe') }}" method="post"
                                class="bg-light p-2 p-md-3 contact-form">
                                @csrf
                                @honeypot
                                <input type="text" placeholder="Nom" name="name" required>
                                @error('name')
                                    <div class="alert alert-danger">{{ $message }}</div>
                                @enderror
                                <input type="text" placeholder="Email adresse" name="email" required>
                                @error('email')
                                    <div class="alert alert-danger">{{ $message }}</div>
                                @enderror
                                <input type="submit" value="Souscrire">
                            </form>
                        </div>
                    </div>
                </div>
            </div>
            <div class="row">
                <div class="col-md-12 text-center">
                    <p>
                        Copyright &copy; {{ config('app.name') }} {{ now()->year }}. All rights reserved
                    </p>
                </div>
            </div>
        </div>
    </footer>
