@extends('frontend.layouts.app', ['current' => 'home'])
@section('page_title', 'Accueil')

@section('content')
    <section class="home-slider js-fullheight owl-carousel">
        @foreach ($sliders as $slider)
            <div class="slider-item js-fullheight"
                style="background-image:url({{ asset('storage/sliders/' . $slider->image . '') }});">
                <div class="overlay"></div>
                <div class="container">
                    <div class="row no-gutters slider-text js-fullheight align-items-center justify-content-center"
                        data-scrollax-parent="true">
                        <div class="col-md-8 text-center ftco-animate mt-5">
                            <div class="text">
                                <div class="subheading">
                                    <span>Peter Byamungu Ministries</span>
                                </div>
                                <h1 class="mb-4">{{ $slider->heading1 }} <span>{{ $slider->heading2 }}</span></h1>
                                <p>{!! $slider->description !!}</p>
                                <p><a href="{{ route('about') }}" class="btn btn-primary py-2 px-4">A propos</a> <a
                                        href="{{ route('contact') }}"
                                        class="btn btn-primary btn-outline-primary py-2 px-4">Contact</a></p>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        @endforeach
    </section>
    <section class="ftco-section ftco-services-2" id="services-section">
        <div class="container">
            <div class="row justify-content-center pb-5">
                {{-- <div class="col-md-6 sermon-wrap ftco-animate  img d-flex align-items-center justify-content-center"
                    style="background-image: url({{ asset('storage/welcomes/' . $welcome->image . '') }}); height:350px"> --}}
                <div class="col-md-6 sermon-wrap ftco-animate  img d-flex align-items-center justify-content-center"
                    style="height:350px">
                    <iframe width="100%" height="350"
                        src="https://www.youtube.com/embed/{{ $welcome->video_link }}?modestbranding=1&autohide=1&showinfo=0&controls=1"
                        title="YouTube video player" frameborder="0"
                        allow="accelerometer; autoplay; clipboard-write; encrypted-media; gyroscope; picture-in-picture; web-share"
                        allowfullscreen></iframe>
                </div>
                <div class="col-md-6 heading-section text-center ftco-animate">
                    <span class="subheading">Bienvenu chez</span>
                    <h2 class="mb-4">Peter Byamungu Ministries</h2>
                    <p>{!! $welcome->welcome_text !!}</p>
                </div>

            </div>
            <div class="row">
                <div class="col-md d-flex align-self-stretch ftco-animate">
                    <div class="media block-6 services text-center d-block">
                        <div class="icon"><span class="flaticon-praying"></span></div>
                        <div class="media-body">
                            <h3 class="heading mb-3">Mandat</h3>
                            <div class="mandat"
                                data-config='{ "type": "text", "limit": 90, "more": "→ voir plus", "less": "← voir moins" }'>
                                {!! $about->mandat !!}
                            </div>
                        </div>
                    </div>
                </div>
                <div class="col-md d-flex align-self-stretch ftco-animate">
                    <div class="media block-6 services text-center d-block">
                        <div class="icon"><span class="flaticon-bible"></span></div>
                        <div class="media-body">
                            <h3 class="heading mb-3">Objectif</h3>
                            <div class="objective"
                                data-config='{ "type": "text", "limit": 90, "more": "→ voir plus", "less": "← voir moins" }'>
                                {!! $about->objective !!}
                            </div>
                        </div>
                    </div>
                </div>
                <div class="col-md d-flex align-self-stretch ftco-animate">
                    <div class="media block-6 services text-center d-block">
                        <div class="icon"><span class="flaticon-church"></span></div>
                        <div class="media-body">
                            <h3 class="heading mb-3">But</h3>
                            <div class="but"
                                data-config='{ "type": "text", "limit": 90, "more": "→ voir plus", "less": "← voir moins" }'>
                                {!! $about->goal !!}
                            </div>
                        </div>
                    </div>
                </div>
                <div class="col-md d-flex align-self-stretch ftco-animate">
                    <div class="media block-6 services text-center d-block">
                        <div class="icon"><span class="flaticon-social-care"></span></div>
                        <div class="media-body">
                            <h3 class="heading mb-3">Mission</h3>
                            <div class="mission"
                                data-config='{ "type": "text", "limit": 90, "more": "→ voir plus", "less": "← voir moins" }'>
                                {!! $about->mission !!}
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            <div class="row mt-4 justify-content-end">
                <div class="col-lg-10">
                    <div class="donated-intro bg-darken p-4 p-md-5">
                        <h2><span>Faire un don</span></h2>
                        <p>Aujourd’hui, notre mission est d’annoncer l’évangile partout dans le monde par des conférences
                            totalement gratuites, des réunions de couples, des festivals musicaux, des évangélisations en
                            milieux scolaires et universitaire, l’octroi de bourses d’études aux étudiants n’ayant pas le
                            moyen de se prendre en charge, la production des chantres gospels, </p>
                        <p>
                            Donnez ce que le Seigneur vous met sur le cœur 10$, 100$, 500$ ou même 1000$.
                        </p>
                        <ul>
                            @if ($setting->airtelmoney)
                                <li>airtel Money: {{ $setting->airtelmoney }}</li>
                            @endif
                            @if ($setting->mpesa)
                                <li>Mpesa: {{ $setting->mpesa }}</li>
                            @endif
                            @if ($setting->orangemoney)
                                <li>airtel Money: {{ $setting->orangemoney }}</li>
                            @endif
                            @if ($setting->bankname && $setting->bankaccount)
                                <li>Banque: {{ $setting->bankname . ': ' . $setting->bankaccount }}</li>
                            @endif
                        </ul>
                        <p>
                            Vous pouvez devenir partenaire mensuel ou donner un seul don ponctuel
                            <a href="{{ route('contact') }}" class="btn btn-black px-4 py-3">Nous contacter!</a>
                        </p>
                    </div>
                </div>
            </div>
        </div>
    </section>

    @if ($verse)
        <section class="ftco-daily-verse img"
            style="background-image: url({{ $verse_image ? asset('storage/verses/images/' . $verse_image->image . '') : '' }});">
            <div class="overlay"></div>
            <div class="container">
                <div class="row justify-content-center">
                    <div class="col-md-10">
                        <div class="row justify-content-center align-items-center">
                            <div class="col-md-2 ftco-animate">
                                <div class="icon">
                                    <span class="flaticon-church"></span>
                                </div>
                            </div>
                            <div class="col-md-10 daily-verse pl-md-5 ftco-animate">
                                <span class="subheading">Verset du jour:</span>
                                <h3>{!! $verse->meditation !!}</h3>
                                <h4 class="h5 mt-4 font-weight-bold"><span>Bible:</span> {{ $verse->verse }}</h4>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </section>
    @endif

    @if ($testimonies->isNotEmpty())
        <section class="ftco-section bg-light" id="sermons-section">
            <div class="container">
                <div class="row justify-content-center pb-5">
                    <div class="col-md-12 heading-section text-center ftco-animate">
                        <span class="subheading">Temoignages</span>
                        <h2 class="mb-4">Quelques Temoignages</h2>
                        <p>Ce que les gens disent de nous</p>
                    </div>
                </div>
                <div class="row">
                    <div id="demo" class="carousel slide" data-ride="carousel">
                        <div class="carousel-inner">
                            @foreach ($testimonies as $testimony)
                                <div class="carousel-item @if ($loop->first) active @endif">
                                    <div class="carousel-caption">
                                        <p>{!! $testimony->description !!}
                                        </p>
                                        @if ($testimony->image)
                                            <img src="{{ asset('storage/testimonies/' . $testimony->image . '') }}"
                                                alt="{{ $testimony->slug }}"
                                                style="height: 84px; width: 84px; object-fit: cover; object-position: center">
                                        @else
                                            <img src="{{ asset('img/users/unknown.jpg') }}"
                                                style="height: 84px; width: 84px; object-fit: cover; object-position: center"
                                                alt="unknown">
                                        @endif
                                        <div id="image-caption">{{ $testimony->title }}</div>
                                    </div>
                                </div>
                            @endforeach
                        </div>
                    </div>
                </div>
            </div>
        </section>
    @endif
    @if (getActivities()->isNotEmpty())
        <section class="ftco-section bg-light" id="sermons-section">
            <div class="container">
                <div class="row justify-content-center pb-5">
                    <div class="col-md-12 heading-section text-center ftco-animate">
                        <span class="subheading">Activités</span>
                        <h2 class="mb-4">Nos Recentes Activités</h2>
                    </div>
                </div>
                <div class="row">
                    @foreach (getActivities() as $activity)
                        <div class="col-md-4">
                            <div class="sermon-wrap ftco-animate">
                                <div class="img d-flex align-items-center justify-content-center"
                                    style="background-image: url({{ $activity->images->isNotEmpty() ? asset('storage/activities/' . $activity->images->first()->image . '') : asset('front_theme/images/image_1.jpg') }});width:349px;height:450px;">
                                    <div class="text-content p-4 text-center">
                                        <p class="">
                                            <a href="{{ route('activity.show', $activity) }}"
                                                class="btn-custom p-2 text-center">
                                                Lire plus</a>
                                        </p>
                                    </div>
                                </div>
                                <div class="text pt-3 text-center">
                                    <h2 class="mb-0"><a
                                            href="{{ route('activity.show', $activity) }}">{{ $activity->title }}</a>
                                    </h2>
                                    <div class="meta">
                                        <p class="mb-0">
                                            <span>{{ Carbon\Carbon::parse($activity->started_at)->format('d-M-Y') }}</span>
                                        </p>
                                    </div>
                                </div>
                            </div>
                        </div>
                    @endforeach
                </div>
            </div>
        </section>
    @endif
    @if ($galleries->isNotEmpty())
        <div class="row justify-content-center mb-5 pb-3">
            <div class="col-md-7 heading-section ftco-animate text-center">
                <h3 class="subheading">Gallery</h3>
                <h2 class="mb-1">Peter Byamungu Ministries Gallerie Photo</h2>
            </div>
        </div>
        <div class="row">
            @foreach ($galleries as $gallery)
                <div class="col-md-3 ftco-animate">
                    <a href="{{ asset('storage/galleries/' . $gallery->image . '') }}"
                        class="gallery image-popup img d-flex align-items-center"
                        style="background-image: url({{ asset('storage/galleries/' . $gallery->image . '') }});">
                        <div class="icon mb-4 d-flex align-items-center justify-content-center">
                            <span class="icon-instagram"></span>
                        </div>
                    </a>
                </div>
            @endforeach
        </div>
        </div>
        </section>
    @endif
@endsection
@section('addCSS')
    {{-- <link rel="stylesheet" href="https://cdn.jsdelivr.net/gh/tomik23/show-more@1.1.6/dist/css/show-more.min.css" /> --}}
    <style>
        /* styling buttons */
        .show-more-btn {
            margin: auto;
            cursor: pointer;
            color: #000;
            white-space: nowrap;
            transition: color 300ms ease-in-out;
            border: 0;
            font-size: 0.8em;
            background: transparent;
        }

        .show-more-btn:hover {
            color: #ffd615;
        }

        .hidden {
            display: none;
        }

        /*owl carousel*/
        .owl-carousel .owl-stage,
        .owl-carousel.owl-drag .owl-item {
            -ms-touch-action: pan-y !important;
            touch-action: pan-y !important;
        }
    </style>
@endsection
@section('addJS')
    <script src="https://cdn.jsdelivr.net/gh/tomik23/show-more@1.1.6/dist/js/showMore.min.js"></script>
    <script>
        (function() {
            new ShowMore('.mandat');
            new ShowMore('.objective');
            new ShowMore('.but');
            new ShowMore('.mission');
        })();
    </script>
@endsection
