@extends('layouts.default',['current' => 'galleries'])
@section("page_title", "Modifier Galérie")
@section('breadcrumb')
    <div class="content-header">
        <div class="container-fluid">
            <div class="row justify-content-end mb-2">
                <div class="col-sm-6">
                    <ol class="breadcrumb float-sm-right">
                        <li class="breadcrumb-item"><a href="{{route('dashboard')}}">Dashboard</a></li>
                        <li class="breadcrumb-item"><a href="{{route('galleries.index')}}">galérie</a></li>
                        <li class="breadcrumb-item active">Modifier Photo</li>
                    </ol>
                </div>
            </div>
        </div>
    </div>
@endsection
@section('content')
    <div class="row">
        <div class="col-md-8">
            <div class="card">
                <div class="card-header card-outline card-primary">
                    <h3 class="card-title">Informations générales</h3>
                </div>
                <form role="form" method="POST" action="{{ route('galleries.update', $gallery) }}">
                    @csrf
                    @method('PUT')
                    <div class="card-body">
                        <div class="row">
                            <div class="col-md-12">
                                <div class="form-group">
                                    <label for="caption">Caption</label>
                                    <input type="text"  name="caption" class="form-control" id="caption"  value="{{$gallery->caption}}" required >
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="card-footer">
                        <button type="button" class="btn btn-danger" data-toggle="modal"
                                data-target="#galleryDeleteModal">
                            <i class="fas fa-trash-alt"></i>
                        </button>
                        <button name="submit" type="submit" class="btn btn-primary float-right">
                            <i class="fas fa-save mr-2"></i>
                            Modifier
                        </button>
                    </div>
                </form>
            </div>
        </div>
        <div class="col-md-4">
            <div class="card mb-3">
                <div class="card-header card-outline card-primary">
                    <h3 class="card-title">
                        Image
                    </h3>
                </div>
                @if ($gallery->image)
                    <div class="card-body text-center p-0">
                        <img class="img-thumbnail"  src="{{ asset('storage/galleries/' . $gallery->image . '') }}"  />
                    </div>
                    <div class="card-footer text-right">
                       <a href="{{route('galleries.image.delete', $gallery)}}" class="btn btn-link">
                            <i class="fas fa-trash-alt text-danger"></i>
                        </a>
                    </div>
                @else
                    <form enctype="multipart/form-data" role="form" method="POST"
                          action="{{route('galleries.image.store', $gallery)}}">
                        @csrf
                        <div class="card-body">
                            <div class="form-group">
                                <div class="input-group">
                                    <div class="custom-file">
                                        <input type="file" class="custom-file-input" id="image" name="image"
                                               accept="image/*">
                                        <label class="custom-file-label" for="image">Choisir image</label>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <div class="card-footer text-right">
                            <button name="submit" type="submit" class="btn btn-primary">
                                <i class="fas fa-save mr-2"></i>
                                Enregistrer
                            </button>
                        </div>
                    </form>
                @endif
            </div>
        </div>

    </div>

    {{-- MODAL DELETE GALERIE --}}
    <form action="{{ route('galleries.destroy',$gallery)}}" method="POST">
        @method('delete')
        @csrf
        <div class="modal fade" id="galleryDeleteModal" tabindex="-1" aria-labelledby="galleryDeleteModalLabel"
             aria-hidden="true">
            <div class="modal-dialog">
                <div class="modal-content">
                    <div class="modal-header">
                        <h5 class="modal-title" id="galleryDeleteModalLabel">SUPPRIMER</h5>
                        <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                            <span aria-hidden="true">&times;</span>
                        </button>
                    </div>
                    <div class="modal-body">
                        <div class="row">
                            <div class="col-md-12">
                                <p>
                                    Etes-vous sûr de vouloir supprimer cette photo?
                                </p>
                            </div>
                        </div>
                    </div>
                    <div class="modal-footer">
                        <button type="button" class="btn btn-secondary" data-dismiss="modal">Annuler</button>
                        <button type="submit" class="btn btn-danger">
                            <i class="fas fa-trash-alt mr-2"></i>
                            SUPPRIMER
                        </button>
                    </div>
                </div>
            </div>
        </div>
    </form>
@endsection
@section('scripts')
    <script src="{{asset('theme/plugins/bs-custom-file-input/bs-custom-file-input.min.js')}}"></script>
    <script>
        $(function () {
            bsCustomFileInput.init();
        });
    </script>
@endsection






