@extends('layouts.default', ['current' => 'profile'])
@section('page_title', 'Modifier profile')
@section('breadcrumb')
    <div class="content-header">
        <div class="container-fluid">
            <div class="row justify-content-end mb-2">
                <div class="col-sm-6">
                    <ol class="breadcrumb float-sm-right">
                        <li class="breadcrumb-item"><a href="{{ route('dashboard') }}">Dashboard</a></li>
                        <li class="breadcrumb-item"><a href="{{ route('abouts.index') }}">Profil</a></li>
                        <li class="breadcrumb-item active">Modifier </li>
                    </ol>
                </div>
            </div>
        </div>
    </div>
@endsection
@section('content')
    <div class="row">
        <div class="col-md-8 mb-3">
            <div class="card">
                <div class="card-header card-outline card-primary">
                    <h3 class="card-title">Informations générales</h3>
                </div>
                <form role="form" method="POST" action="{{ route('profile.update') }}">
                    @csrf
                    <div class="card-body">
                        <div class="row">
                            <div class="col-md-12">
                                <div class="form-group">
                                    <label for="name">Nom complet *</label>
                                    <input type="text" class="form-control" id="name" name="name"
                                        placeholder="Nom complet" value="{{ $auth->name ? $auth->name : old('name') }}" />
                                    @error('name')
                                        <span class="small text-danger" role="alert">{{ $message }}</span>
                                    @enderror
                                </div>
                            </div>
                        </div>
                        <div class="row">
                            <div class="col-md-12">
                                <div class="form-group">
                                    <label for="email">Email *</label>
                                    <input type="text" class="form-control" id="email" name="email"
                                        placeholder="Email" value="{{ $auth->email ? $auth->email : old('email') }}" />
                                    @error('email')
                                        <span class="small text-danger" role="alert">{{ $message }}</span>
                                    @enderror
                                </div>
                            </div>
                        </div>

                        <div class="row">
                            <div class="col-md-12">
                                <div class="form-group">
                                    <label for="password">Mot de passe</label>
                                    <input type="password" class="form-control" id="password" name="password"
                                        placeholder="password" value="{{ old('password') }}" />
                                    @error('password')
                                        <span class="small text-danger" role="alert">{{ $message }}</span>
                                    @enderror
                                </div>
                            </div>
                        </div>
                        <div class="row">
                            <div class="col-md-12">
                                <div class="form-group">
                                    <label for="password_confirmation">Confirmer Mot de passe</label>
                                    <input type="password" class="form-control" id="password_confirmation"
                                        name="password_confirmation" placeholder="password_confirmation"
                                        value="{{ old('password_confirmation') }}" />
                                    @error('password_confirmation')
                                        <span class="small text-danger" role="alert">{{ $message }}</span>
                                    @enderror
                                </div>
                            </div>
                        </div>


                        <div class="row">
                            <div class="col small text-danger">
                                Les champs * sont obligatoires
                            </div>
                        </div>
                    </div>
                    <div class="card-footer">
                        <button name="submit" type="submit" class="btn btn-primary float-right">
                            <i class="fas fa-save"></i>
                            Enregistrer
                        </button>
                    </div>
                </form>
            </div>
        </div>

    </div>
@endsection
@section('scripts')
    <script src="{{ asset('theme/plugins/bs-custom-file-input/bs-custom-file-input.min.js') }}"></script>
@endsection
