@extends('layouts.default', ['current' => 'settings'])
@section('page_title', 'Modifier setting')
@section('breadcrumb')
    <div class="content-header">
        <div class="container-fluid">
            <div class="row justify-content-end mb-2">
                <div class="col-sm-6">
                    <ol class="breadcrumb float-sm-right">
                        <li class="breadcrumb-item"><a href="{{ route('dashboard') }}">Dashboard</a></li>
                        <li class="breadcrumb-item"><a href="{{ route('settings.index') }}">settings</a></li>
                        <li class="breadcrumb-item active">Modifier settings</li>
                    </ol>
                </div>
            </div>
        </div>
    </div>
@endsection
@section('content')
    <div class="row">
        <div class="col-md-8 mb-3">
            <div class="card">
                <div class="card-header card-outline card-primary">
                    <h3 class="card-title">Informations générales</h3>
                </div>
                <form role="form" method="POST" action="{{ route('settings.update', $setting) }}">
                    @csrf
                    @method('PUT')
                    <div class="card-body">
                        <div class="row">
                            <div class="col-md-12">
                                <div class="form-group">
                                    <label for="airtelmoney">AirtelMoney</label>
                                    <input type="text" name="airtelmoney" class="form-control" id="airtelmoney" value="{{ $setting->airtelmoney ? $setting->airtelmoney : old('airtelmoney') }}"
                                           placeholder="ex : +243...">
                                    @error('airtelmoney')
                                        <span class="small text-danger" role="alert">{{ $message }}</span>
                                    @enderror
                                </div>
                            </div>
                        </div>
                        <div class="row">
                            <div class="col-md-6">
                                <div class="form-group">
                                    <label for="orangemoney">OrangeMoney</label>
                                    <input type="text" name="orangemoney" class="form-control" id="orangemoney"
                                        value="{{ $setting->orangemoney ? $setting->orangemoney : old('orangemoney') }}" placeholder="ex : +243...">
                                    @error('orangemoney')
                                        <span class="small text-danger" role="alert">{{ $message }}</span>
                                    @enderror
                                </div>
                            </div>
                            <div class="col-md-6">
                                <div class="form-group">
                                    <label for="mpesa">Mpesa</label>
                                    <input type="text" name="mpesa" class="form-control" id="mpesa"
                                        value="{{ $setting->mpesa ? $setting->mpesa : old('mpesa') }}" placeholder="ex : +243...">
                                    @error('mpesa')
                                    <span class="small text-danger" role="alert">{{ $message }}</span>
                                    @enderror
                                </div>
                            </div>
                        </div>
                        <div class="row">
                        <div class="col-md-6">
                                <div class="form-group">
                                    <label for="bankname">BankName</label>
                                    <input type="text" name="bankname" class="form-control" id="bankname"
                                        value="{{ $setting->bankname ? $setting->bankname : old('bankname') }}" placeholder="ex : FBN Bank">
                                    @error('bankname')
                                    <span class="small text-danger" role="alert">{{ $message }}</span>
                                    @enderror
                                </div>
                            </div>
                            <div class="col-md-6">
                                <div class="form-group">
                                    <label for="bankaccount">BankAccount</label>
                                    <input type="text" name="bankaccount" class="form-control" id="bankaccount"
                                        value="{{ $setting->bankaccount ? $setting->bankaccount : old('bankaccount') }}" placeholder="ex : 003034...">
                                    @error('bankaccount')
                                    <span class="small text-danger" role="alert">{{ $message }}</span>
                                    @enderror
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="card-footer">
                        @if($settings->count() > 1)
                            <button type="button" class="btn btn-danger" data-toggle="modal"
                                    data-target="#settingDeleteModal">
                                <i class="fas fa-trash-alt"></i>
                            </button>
                        @endif
                        <button name="submit" type="submit" class="btn btn-primary float-right">
                            <i class="fas fa-save"></i>
                            Enregistrer
                        </button>
                    </div>
                </form>
            </div>
        </div>

        <!-- DELETE setting MODAL -->
        <form action="{{ route('settings.destroy', $setting) }}" method="POST">
            @method('delete')
            @csrf
            <div class="modal fade" id="settingDeleteModal" tabindex="-1"
                 aria-labelledby="settingDeleteModalLabel" aria-hidden="true">
                <div class="modal-dialog">
                    <div class="modal-content">
                        <div class="modal-header">
                            <h5 class="modal-title" id="settingDeleteModalLabel">Supprimer setting</h5>
                            <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                                <span aria-hidden="true">&times;</span>
                            </button>
                        </div>
                        <div class="modal-body">
                            <input type="hidden" id="setting_id" name="setting_id">
                            <span>
                            Etes-vous sûr de vouloir supprimer ce setting?
                        </span>
                        </div>
                        <div class="modal-footer">
                            <button type="button" class="btn btn-secondary" data-dismiss="modal">annuler</button>
                            <button type="submit" class="btn btn-danger">Supprimer setting</button>
                        </div>
                    </div>
                </div>
            </div>
        </form>
@endsection
        