@extends('layouts.default', ['current' => 'settings'])
@section('page_title', 'Settings')
@section('breadcrumb')
    <div class="content-header">
        <div class="container-fluid">
            <div class="row justify-content-end mb-2">
                <div class="col-sm-6">
                    <ol class="breadcrumb float-sm-right">
                        <li class="breadcrumb-item"><a href="#">Dashboard</a></li>
                        <li class="breadcrumb-item active">Settings</li>
                    </ol>
                </div>
            </div>
        </div>
    </div>
@endsection
@section('content')
    <div class="row">
        <div class="col-12">
            <div class="card">
                <div class="card-header">
                    <h2 class="card-title">Settings</h2>
                    @if($settings->count() < 1)
                        <div class="card-tools">
                            <button type="button" class="btn btn-primary" data-toggle="modal" data-target="#settingModal">
                                <i class="fas fa-plus mr-2"></i>
                                Ajouter
                            </button>
                        </div>
                    @endif
                </div>
                
                <div class="card-body table-responsive p-0">
                    <table class="table table-hover table-sm text-nowrap" id="settingTable">
                        <thead class="tbl-head bg-dark-light">
                        <tr>
                            <th style="width: 5%;">#</th>
                            <th style="min-width: 20%;">AirtelMoney</th>
                            <th style="min-width: 20%;">OrangeMoney</th>
                            <th style="min-width: 20%;">Mpesa</th>
                            <th style="min-width: 20%;">BankName</th>
                            <th style="min-width: 10%;">BankAccount</th>
                            <th style="width: 10%;"></th>
                        </tr>
                        </thead>
                        <tbody>
                        @if($settings->isNotEmpty())
                            @forelse($settings as $setting)
                                <tr>
                                    <td>{{ $loop->iteration }}.</td>
                                    <td>
                                        <span>{{ $setting->airtelmoney }}</span>
                                    </td>
                                    <td>
                                        {{ $setting->orangemoney }}
                                    </td>
                                    <td>
                                        {{ $setting->mpesa }}
                                    </td>
                                    <td>
                                        {{ $setting->bankname }}
                                    </td>
                                    <td>
                                        {{ $setting->bankaccount }}
                                    </td>
                                    <td class="d-flex justify-content-end">
                                        <a href="{{ route('settings.edit', $setting) }}">
                                            <i class="fas mr-2 fa-edit text-warning" title="Modifier"></i>
                                        </a>
                                    </td>
                                </tr>
                            @empty
                                <tr>
                                    <td colspan="7" style="text-align: center;">Aucune setting enregistrée!</td>
                                </tr>
                            @endforelse
                        @else    
                            <tr>
                                <td colspan="7" style="text-align: center;">Aucune setting enregistrée!</td>
                            </tr>
                        @endif

                        </tbody>
                    </table>
                </div>
            </div>
        </div>
    </div>

    {{-- MODAL ADD SETTING --}}
    <form action="{{ route('settings.store') }}" method="POST" enctype="multipart/form-data" autocomplete="off">
        @csrf
        <div class="modal fade" id="settingModal" tabindex="-1" aria-labelledby="settingModal"
             aria-hidden="true">
            <div class="modal-dialog modal-sm">
                <div class="modal-content" style="width: 500px;">
                    <div class="modal-header">
                        <h5 class="modal-title" id="settingModal">AJOUTER </h5>
                        <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                            <span aria-hidden="true">&times;</span>
                        </button>
                    </div>
                    <div class="modal-body">
                        <div class="row">
                            <div class="col-md-12">
                                <div class="form-group">
                                    <label for="airtelmoney">AirtelMoney</label>
                                    <input type="text" name="airtelmoney" class="form-control" id="airtelmoney" required
                                           placeholder="ex : +243...">
                                </div>
                            </div>
                        </div>
                        <div class="row">
                            <div class="col-md-6">
                                <div class="form-group">
                                    <label for="orangemoney">OrangeMoney</label>
                                    <input type="text" name="orangemoney" class="form-control" id="orangemoney" required
                                           placeholder="ex : +243...">
                                </div>
                            </div>
                            <div class="col-md-6">
                                <div class="form-group">
                                    <label for="mpesa">Mpesa</label>
                                    <input type="text" name="mpesa" class="form-control" id="mpesa" required
                                           placeholder="ex : +243...">
                                </div>
                            </div>
                        </div>
                        <div class="row">
                            <div class="col-md-6">
                                <div class="form-group">
                                    <label for="bankname">BankName</label>
                                    <input type="text" name="bankname" class="form-control" id="bankname" required
                                           placeholder="ex : FBN Bank">
                                </div>
                            </div>
                            <div class="col-md-6">
                                <div class="form-group">
                                    <label for="bankaccount">BankAccount</label>
                                    <input type="text" name="bankaccount" class="form-control" id="bankaccount" required
                                           placeholder="ex : 003034...">
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="modal-footer ">
                        <button type="button" class="btn btn-secondary" data-dismiss="modal">Annuler</button>
                        <button type="submit" class="btn btn-primary">
                            <i class="fas fa-save mr-2"></i>
                            Enregistrer
                        </button>
                    </div>
                </div>
            </div>
        </div>
    </form>
@endsection






