@extends('layouts.default', ['current' => 'sliders'])
@section('page_title', 'Modifier slider')
@section('breadcrumb')
    <div class="content-header">
        <div class="container-fluid">
            <div class="row justify-content-end mb-2">
                <div class="col-sm-6">
                    <ol class="breadcrumb float-sm-right">
                        <li class="breadcrumb-item"><a href="{{ route('dashboard') }}">Dashboard</a></li>
                        <li class="breadcrumb-item"><a href="{{ route('sliders.index') }}">sliders</a></li>
                        <li class="breadcrumb-item active">Modifier slider </li>
                    </ol>
                </div>
            </div>
        </div>
    </div>
@endsection
@section('content')
    <div class="row">
        <div class="col-md-8 mb-3">
            <div class="card">
                <div class="card-header card-outline card-primary">
                    <h3 class="card-title">Informations générales</h3>
                </div>
                <form role="form" method="POST" action="{{ route('sliders.update', $slider) }}">
                    @csrf
                    @method('PUT')
                    <div class="card-body">
                        <div class="row">
                            <div class="col-md-12">
                                <div class="form-group">
                                    <label for="heading1">Heading 1 <span class="text-danger">*</span></label>
                                    <input type="text" name="heading1" class="form-control" id="heading1"
                                           value="{{ $slider->heading1 ? $slider->heading1 : old('heading1') }}"
                                           placeholder="Ex. chantre" required>
                                    @error('heading1')
                                    <span class="small text-danger" role="alert">{{ $message }}</span>
                                    @enderror
                                </div>
                            </div>
                        </div>
                        <div class="row">
                            <div class="col-md-12">
                                <div class="form-group">
                                    <label for="heading2">Heading 2 <span class="text-danger">*</span></label>
                                    <input type="text" name="heading2" class="form-control" id="heading2"
                                           value="{{ $slider->heading2 ? $slider->heading2 : old('heading2') }}"
                                           placeholder="Ex. chantre" required>
                                    @error('heading2')
                                    <span class="small text-danger" role="alert">{{ $message }}</span>
                                    @enderror
                                </div>
                            </div>
                        </div>
                        <div class="row">
                            <div class="col-md-12">
                                <div class="form-group">
                                    <label for="description">Description</label>
                                    <textarea class="form-control" id="description" name="description" rows="5"
                                              placeholder="Description...">
                                              {{ $slider->description ? html_entity_decode($slider->description) : old('description') }}
                                    </textarea>
                                    @error('description')
                                    <span class="small text-danger" role="alert">{{ $message }}</span>
                                    @enderror
                                </div>
                            </div>
                        </div>                     
                        <div class="row">
                            <div class="col small text-danger">
                                Les champs * sont obligatoires
                            </div>
                        </div>
                    </div>
                    <div class="card-footer">
                        <button type="button" class="btn btn-danger" data-toggle="modal"
                                data-target="#sliderDeleteModal">
                            <i class="fas fa-trash-alt"></i>
                        </button>
                        <button name="submit" type="submit" class="btn btn-primary float-right">
                            <i class="fas fa-save"></i>
                            Enregistrer
                        </button>
                    </div>
                </form>
            </div>
        </div>
        <div class="col-md-4">
            <div class="card mb-3">
                <div class="card-header card-outline card-primary">
                    <h3 class="card-title">
                        Image
                    </h3>
                </div>
                @if ($slider->image)
                    <div class="card-body text-center p-0">
                        <img class="img-thumbnail w-100" src="{{ asset('storage/sliders/' . $slider->image . '') }}"
                             alt="{{ $slider->slug }}">
                    </div>
                    <div class="card-footer text-right">
                        <a href="{{ route('sliders.image.delete', $slider) }}" class="btn btn-link">
                            <i class="fas fa-trash-alt text-danger"></i>
                        </a>
                    </div>
                @else
                    <form enctype="multipart/form-data" role="form" method="POST"
                          action="{{ route('sliders.image.store', $slider) }}">
                        @csrf
                        <div class="card-body">
                            <div class="form-group">
                                <div class="input-group">
                                    <div class="custom-file">
                                        <input type="file" class="custom-file-input" id="image" name="image"
                                               accept="image/*">
                                        <label class="custom-file-label" for="image">Choisir image</label>
                                    </div>
                                </div>
                            </div>

                        </div>
                        <div class="card-footer text-right">
                            <button name="submit" type="submit" class="btn btn-primary">
                                <i class="fas fa-save mr-2"></i>
                                Enregistrer
                            </button>
                        </div>
                    </form>
                @endif
            </div>
        </div>
    </div>

    <!-- DELETE slider member MODAL -->
    <form action="{{ route('sliders.destroy', $slider) }}" method="POST">
        @method('delete')
        @csrf
        <div class="modal fade" id="sliderDeleteModal" tabindex="-1"
                aria-labelledby="sliderDeleteModalLabel" aria-hidden="true">
            <div class="modal-dialog">
                <div class="modal-content">
                    <div class="modal-header">
                        <h5 class="modal-title" id="sliderDeleteModalLabel">Supprimer slider</h5>
                        <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                            <span aria-hidden="true">&times;</span>
                        </button>
                    </div>
                    <div class="modal-body">
                        <input type="hidden" id="slider_id" name="slider_id">
                        <span>
                    Etes-vous sûr de vouloir supprimer ce slider?
                </span>
                    </div>
                    <div class="modal-footer">
                        <button type="button" class="btn btn-secondary" data-dismiss="modal">annuler</button>
                        <button type="submit" class="btn btn-danger">Supprimer slider</button>
                    </div>
                </div>
            </div>
        </div>
    </form>
@endsection
@section('scripts')
    <script src="{{ asset('theme/plugins/bs-custom-file-input/bs-custom-file-input.min.js') }}"></script>
    <script>
        $(function () {
            bsCustomFileInput.init();
        });
    </script>
    @include('partials._ckeditor')
@endsection
