@extends('layouts.default', ['current' => 'subscriptions'])
@section('page_title', 'Subscriptions')
@section('breadcrumb')
    <div class="content-header">
        <div class="container-fluid">
            <div class="row justify-content-end mb-2">
                <div class="col-sm-6">
                    <ol class="breadcrumb float-sm-right">
                        <li class="breadcrumb-item"><a href="{{ route('dashboard') }}">Dashboard</a></li>
                        <li class="breadcrumb-item active">Emails list</li>
                    </ol>
                </div>
            </div>
        </div>
    </div>
@endsection
@section('content')
    <div class="row">
        <div class="col-12">
            <div class="card">
                <div class="card-header">
                    <h2 class="card-title">Emails list</h2>
                </div>
                <div class="card-header">
                    <div class="row justify-content-end">
                        <div class="col-md-2">
                            <div class="input-group input-group-sm">
                                <input type="text" name="table_search" class="form-control float-right"
                                    placeholder="Search">
                                <div class="input-group-append">
                                    <button type="submit" class="btn btn-default">
                                        <i class="fas fa-search"></i>
                                    </button>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="card-body table-responsive p-0">
                    <table class="table table-hover  table-sm text-nowrap">
                        <thead class="tbl-head bg-dark-light">
                            <tr>
                                <th style="width: 5%;">#</th>
                                <th style="min-width: 30%;">Nom</th>
                                <th style="min-width: 30%;">Email</th>
                                <th style="min-width: 30%;">Statut</th>
                                <th style="width: 10%;"></th>
                            </tr>
                        </thead>
                        <tbody>
                            @if ($subscriptions->isNotEmpty())
                                @forelse($subscriptions as $subscription)
                                    <tr>
                                        <td>{{ $loop->iteration }}.</td>
                                        <td>
                                            <a href="">
                                                <span>{{ $subscription->name }}</span>
                                            </a>
                                        </td>
                                        <td>
                                            <a href="{{ route('subscriptions.edit', ['subscription' => $subscription]) }}">
                                                <span>{{ $subscription->email }}</span>
                                            </a>
                                        </td>
                                        <td>
                                            @if ($subscription->status == 1)
                                                Abonné
                                            @else
                                                Désabonné
                                            @endif
                                        </td>
                                        <td class="d-flex justify-content-end">
                                            <a href="{{ route('subscriptions.sendEmail', $subscription) }}">
                                                <i class="fas mr-2 fa-send text-warning" title="Envoyer"></i>
                                            </a>
                                        </td>
                                    </tr>
                                @empty
                                    <tr>
                                        <td colspan="5" style="text-align: center;">Aucun abonnement enregistré!</td>
                                    </tr>
                                @endforelse
                            @else
                                <tr>
                                    <td colspan="5" style="text-align: center;">Aucun abonnement enregistré!</td>
                                </tr>
                            @endif
                        </tbody>
                    </table>
                </div>
                @if ($subscriptions->hasPages())
                    <div class="card-footer clearfix">
                        <ul class="pagination pagination-sm m-0 float-right">
                            <li class="page-item">
                                <a class="btn btn-default btn-sm {{ $subscriptions->onFirstPage() ? 'disabled' : null }}"
                                    href="{{ $subscriptions->previousPageUrl() }}">&laquo;</a>
                            </li>
                            <li class="page-item">
                                <a href="{{ $subscriptions->nextPageUrl() }}"
                                    class="btn btn-default btn-sm {{ !$subscriptions->hasMorePages() ? 'disabled' : null }}">&raquo;</a>
                            </li>
                        </ul>
                    </div>
                @endif
            </div>
        </div>
    </div>
@endsection
