@extends('layouts.default', ['current' => 'testimonies'])
@section('page_title', 'Témoignages')
@section('breadcrumb')
    <div class="content-header">
        <div class="container-fluid">
            <div class="row justify-content-end mb-2">
                <div class="col-sm-6">
                    <ol class="breadcrumb float-sm-right">
                        <li class="breadcrumb-item"><a href="{{ route('dashboard') }}">Dashboard</a></li>
                        <li class="breadcrumb-item active">Témoignages</li>
                    </ol>
                </div>
            </div>
        </div>
    </div>
@endsection
@section('content')
    <div class="row">
        <div class="col-12">
            <div class="card">
                <div class="card-header">
                    <h2 class="card-title">Témoignages</h2>
                    <div class="card-tools">
                        <button type="button" class="btn btn-primary" data-toggle="modal"
                            data-target="#testimonyStoreModal">
                            <i class="fas fa-plus mr-2"></i>
                            Ajouter témoignage
                        </button>
                    </div>
                </div>
                <div class="card-header">
                    <div class="row justify-content-end">
                        <div class="col-md-2">
                            <div class="input-group input-group-sm">
                                <input type="text" name="table_search" class="form-control float-right"
                                    placeholder="Search">
                                <div class="input-group-append">
                                    <button type="submit" class="btn btn-default">
                                        <i class="fas fa-search"></i>
                                    </button>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="card-body table-responsive p-0">
                    <table class="table table-hover  table-sm text-nowrap">
                        <thead class="tbl-head bg-dark-light">
                            <tr>
                                <th style="width: 5%;">#</th>
                                <th style="min-width: 30%;">Titre</th>
                                <th style="width: 10%;"></th>
                            </tr>
                        </thead>
                        <tbody>
                            @if ($testimonies->isNotEmpty())
                                @forelse($testimonies as $testimony)
                                    <tr>
                                        <td>{{ $loop->iteration }}.</td>
                                        <td>
                                            <a href="{{ route('testimonies.edit', ['testimony' => $testimony]) }}">
                                                @if ($testimony->image)
                                                    <img class="mr-2"
                                                        src="{{ asset('storage/testimonies/' . $testimony->image . '') }}"
                                                        style="height: 24px; width: 24px; object-fit: cover; object-position: center"
                                                        alt="{{ $testimony->slug }}">
                                                @else
                                                    <img class="mr-2" src="{{ asset('img/users/unknown.jpg') }}"
                                                        style="height: 24px; width: 24px; object-fit: cover; object-position: center"
                                                        alt="unknown">
                                                @endif
                                                <span>{{ $testimony->title }}</span>
                                            </a>
                                        </td>
                                        <td class="d-flex justify-content-end">
                                            <a href="{{ route('testimonies.edit', $testimony) }}">
                                                <i class="fas mr-2 fa-edit text-warning" title="Modifier"></i>
                                            </a>
                                        </td>
                                    </tr>
                                @empty
                                    <tr>
                                        <td colspan="5" style="text-align: center;">Aucun témoignage enregistré!</td>
                                    </tr>
                                @endforelse
                            @else
                                <tr>
                                    <td colspan="5" style="text-align: center;">Aucun témoignage enregistré!</td>
                                </tr>
                            @endif
                        </tbody>
                    </table>
                </div>
                @if ($testimonies->hasPages())
                    <div class="card-footer clearfix">
                        <ul class="pagination pagination-sm m-0 float-right">
                            <li class="page-item">
                                <a class="btn btn-default btn-sm {{ $testimonies->onFirstPage() ? 'disabled' : null }}"
                                    href="{{ $testimonies->previousPageUrl() }}">&laquo;</a>
                            </li>
                            <li class="page-item">
                                <a href="{{ $testimonies->nextPageUrl() }}"
                                    class="btn btn-default btn-sm {{ !$testimonies->hasMorePages() ? 'disabled' : null }}">&raquo;</a>
                            </li>
                        </ul>
                    </div>
                @endif
            </div>
        </div>
    </div>

    {{--  ADD TESTIMONY MODAL --}}
    <form enctype="multipart/form-data" action="{{ route('testimonies.store') }}" method="POST">
        @csrf
        <div class="modal fade" id="testimonyStoreModal" tabindex="-1" aria-labelledby="testimonyStoreModalLabel"
            aria-hidden="true">
            <div class="modal-dialog">
                <div class="modal-content">
                    <div class="modal-header">
                        <h5 class="modal-title" id="testimonyStoreModalLabel">AJOUTER Témoignage</h5>
                        <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                            <span aria-hidden="true">&times;</span>
                        </button>
                    </div>
                    <div class="modal-body">
                        <div class="row">
                            <div class="col-md-12">
                                <div class="form-group">
                                    <label for="title">Titre <span class="text-danger">*</span></label>
                                    <input type="text" name="title" class="form-control" id="title"
                                        value="{{ old('title') }}" placeholder="Ex. Chantre" required>
                                </div>
                            </div>
                        </div>
                        <div class="row">
                            <div class="col-md-12">
                                <div class="form-group">
                                    <label for="description">Description</label>
                                    <textarea class="form-control" id="description" name="description"
                                        placeholder="Faîtes une description détaillée de l' activité" style="width: 100%; height: 200px;"></textarea>
                                </div>
                            </div>
                        </div>
                        <div class="row">
                            <div class="col-md-12">
                                <div class="form-group">
                                    <label for="image">Image <span class="text-danger">*</span></label>
                                    <div class="input-group">
                                        <div class="custom-file">
                                            <input value="{{ old('image') }}" type="file" class="custom-file-input"
                                                name="image" id="image" accept="image/*">
                                            <label class="custom-file-label" for="image">Choisir image</label>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <div class="row">
                            <div class="col-md-4">
                                <div class="card mb-3">
                                    <div class="card-body text-center p-0">
                                        <img class="img-thumbnail w-100" id="testimony_img" src="#"
                                            alt="Image">
                                    </div>
                                </div>
                            </div>
                        </div>
                        <div class="modal-footer">
                            <button type="button" class="btn btn-secondary" data-dismiss="modal">Annuler</button>
                            <button type="submit" class="btn btn-primary">
                                <i class="fas fa-save mr-2"></i>
                                Enregistrer
                            </button>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </form>
@endsection
@section('scripts')
    @include('partials._ckeditor')
    <script src="{{ asset('theme/plugins/bs-custom-file-input/bs-custom-file-input.min.js') }}"></script>
    <script>
        $(function() {
            bsCustomFileInput.init();
        });
    </script>
    <script type="text/javascript">
        function readURL(input) {
            if (input.files && input.files[0]) {
                var reader = new FileReader();

                reader.onload = function(e) {
                    $('#testimony_img').attr('src', e.target.result);
                }

                reader.readAsDataURL(input.files[0]);
            }
        }

        $("#image").change(function() {
            readURL(this);
        });
    </script>
@endsection
