@extends('layouts.default', ['current' => 'verses'])
@section('page_title', 'Modifier verset')
@section('breadcrumb')
    <div class="content-header">
        <div class="container-fluid">
            <div class="row justify-content-end mb-2">
                <div class="col-sm-6">
                    <ol class="breadcrumb float-sm-right">
                        <li class="breadcrumb-item"><a href="{{ route('dashboard') }}">Dashboard</a></li>
                        <li class="breadcrumb-item"><a href="{{ route('verses.index') }}">versets</a></li>
                        <li class="breadcrumb-item active">Modifier verset</li>
                    </ol>
                </div>
            </div>
        </div>
    </div>
@endsection
@section('content')
    <div class="row">
        <div class="col-md-8 mb-3">
            <div class="card">
                <div class="card-header card-outline card-primary">
                    <h3 class="card-title">Informations générales</h3>
                </div>
                <form role="form" method="POST" action="{{ route('verses.update', $verse) }}">
                    @csrf
                    @method('PUT')
                    <div class="card-body">
                        <div class="row">
                            <div class="col-md-6">
                                <div class="form-group">
                                    <label for="name">Verset <span class="text-danger">*</span></label>
                                    <input type="text" name="name" class="form-control" id="name"
                                           value="{{ $verse->verse ? $verse->verse : old('name') }}"
                                           placeholder="Ex. Jus mango" required>
                                    @error('name')
                                    <span class="small text-danger" role="alert">{{ $message }}</span>
                                    @enderror
                                </div>
                            </div>
                            <div class="col-sm-6">
                                <div class="form-group">
                                    <label>Date <span class="text-danger">*</span></label>
                                    <div class="input-group">
                                        <div class="input-group-prepend">
                                            <span class="input-group-text"><i class="far fa-calendar-alt"></i></span>
                                        </div>
                                        <input type="date" name="start_date" id="start_date" class="form-control"
                                               placeholder="dd-mm-yyyy" value="{{ $verse->date ? $verse->date : old('start_date') }}" required>
                                        @error('start_date')
                                        <span class="small text-danger" role="alert">{{ $message }}</span>
                                        @enderror
                                    </div>
                                </div>
                            </div>
                        </div>
                        <div class="row">
                            <div class="col-sm-12">
                                <div class="form-group">
                                    <label>Méditation</label>
                                    <textarea name="description" id="description" class="form-control" rows="5"
                                              placeholder="Ajouter une brève description">{{ $verse->meditation ? html_entity_decode($verse->meditation) : old('description') }}</textarea>
                                    @error('description')
                                    <span class="small text-danger" role="alert">{{ $message }}</span>
                                    @enderror
                                </div>
                            </div>
                        </div>
                        <div class="row">
                            <div class="col small text-danger">
                                Les champs * sont obligatoires
                            </div>
                        </div>
                    </div>
                    <div class="card-footer">
                        <button type="button" class="btn btn-danger" data-toggle="modal"
                                data-target="#verseDeleteModal">
                            <i class="fas fa-trash-alt"></i>
                        </button>
                        <button name="submit" type="submit" class="btn btn-primary float-right">
                            <i class="fas fa-save"></i>
                            Enregistrer
                        </button>
                    </div>
                </form>
            </div>
        </div>
        <div class="col-md-4">
            <div class="card mb-3">
                <div class="card-header card-outline card-primary">
                    <h3 class="card-title">
                        Image
                    </h3>
                </div>
                @if ($verse->image)
                    <div class="card-body text-center p-0">
                        <img class="img-thumbnail w-100" src="{{ asset('storage/verses/' . $verse->image . '') }}"
                             alt="{{ $verse->slug }}">
                    </div>
                    <div class="card-footer text-right">
                        <a href="{{ route('verses.image.delete', $verse) }}" class="btn btn-link">
                            <i class="fas fa-trash-alt text-danger"></i>
                        </a>
                    </div>
                @else
                    <form enctype="multipart/form-data" role="form" method="POST"
                          action="{{ route('verses.image.store', $verse) }}">
                        @csrf
                        <div class="card-body">
                            <div class="form-group">
                                <div class="input-group">
                                    <div class="custom-file">
                                        <input type="file" class="custom-file-input" id="image" name="image"
                                               accept="image/*">
                                        <label class="custom-file-label" for="image">Choisir image</label>
                                    </div>
                                </div>
                            </div>

                        </div>
                        <div class="card-footer text-right">
                            <button name="submit" type="submit" class="btn btn-primary">
                                <i class="fas fa-save mr-2"></i>
                                Enregistrer
                            </button>
                        </div>
                    </form>
                @endif
            </div>
        </div>
    </div>

    <!-- DELETE verse MODAL -->
    <form action="{{ route('verses.destroy', $verse) }}" method="POST">
        @method('delete')
        @csrf
        <div class="modal fade" id="verseDeleteModal" tabindex="-1"
                aria-labelledby="verseDeleteModalLabel" aria-hidden="true">
            <div class="modal-dialog">
                <div class="modal-content">
                    <div class="modal-header">
                        <h5 class="modal-title" id="verseDeleteModalLabel">Supprimer verset</h5>
                        <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                            <span aria-hidden="true">&times;</span>
                        </button>
                    </div>
                    <div class="modal-body">
                        <input type="hidden" id="verse_id" name="verse_id">
                        <span>
                    Etes-vous sûr de vouloir supprimer ce verset?
                </span>
                    </div>
                    <div class="modal-footer">
                        <button type="button" class="btn btn-secondary" data-dismiss="modal">annuler</button>
                        <button type="submit" class="btn btn-danger">Supprimer verset</button>
                    </div>
                </div>
            </div>
        </div>
    </form>
@endsection
@section('scripts')
    <script src="{{ asset('theme/plugins/bs-custom-file-input/bs-custom-file-input.min.js') }}"></script>
    <script>
        $(function () {
            bsCustomFileInput.init();
        });
    </script>
    @include("partials._ckeditor")
@endsection
