@extends('layouts.default', ['current' => 'verses'])
@section('page_title', 'Versets')
@section('breadcrumb')
    <div class="content-header">
        <div class="container-fluid">
            <div class="row justify-content-end mb-2">
                <div class="col-sm-6">
                    <ol class="breadcrumb float-sm-right">
                        <li class="breadcrumb-item"><a href="{{ route('dashboard') }}">Dashboard</a></li>
                        <li class="breadcrumb-item active">Versets</li>
                    </ol>
                </div>
            </div>
        </div>
    </div>
@endsection
@section('content')
    <div class="row">
        <div class="col-8">
            <div class="card">
                <div class="card-header">
                    <h2 class="card-title">Versets</h2>
                    <div class="card-tools">
                        <button type="button" class="btn btn-primary" data-toggle="modal" data-target="#verseStoreModal">
                            <i class="fas fa-plus mr-2"></i>
                            Ajouter Verset
                        </button>
                    </div>
                </div>
                <div class="card-header">
                    <div class="row justify-content-end">
                        <div class="col-md-2">
                            <div class="input-group input-group-sm">
                                <input type="text" name="table_search" class="form-control float-right"
                                    placeholder="Search">
                                <div class="input-group-append">
                                    <button type="submit" class="btn btn-default">
                                        <i class="fas fa-search"></i>
                                    </button>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="card-body table-responsive p-0">
                    <table class="table table-hover  table-sm text-nowrap">
                        <thead class="tbl-head bg-dark-light">
                            <tr>
                                <th style="width: 5%;">#</th>
                                <th style="min-width: 30%;">verset</th>
                                <th>Date</th>
                                <th style="width: 10%;"></th>
                            </tr>
                        </thead>
                        <tbody>
                            @if ($verses->isNotEmpty())
                                @forelse($verses as $verse)
                                    <tr>
                                        <td>{{ $loop->iteration }}.</td>
                                        <td>
                                            <a href="{{ route('verses.edit', ['verse' => $verse]) }}">
                                                @if ($verse->image)
                                                    <img class="mr-2"
                                                        src="{{ asset('storage/verses/' . $verse->image . '') }}"
                                                        style="height: 24px; width: 24px; object-fit: cover; object-position: center"
                                                        alt="{{ $verse->verse }}">
                                                @endif
                                                <span>{{ $verse->title }}</span>
                                            </a>
                                        </td>
                                        <td>
                                            {{ Carbon\Carbon::parse($verse->date)->format('d-m-Y') }}
                                        </td>
                                        <td class="d-flex justify-content-end">
                                            <a href="{{ route('verses.edit', $verse) }}">
                                                <i class="fas mr-2 fa-edit text-warning" title="Modifier"></i>
                                            </a>
                                        </td>
                                    </tr>
                                @empty
                                    <tr>
                                        <td colspan="5" style="text-align: center;">Aucune Verset enregistrée!</td>
                                    </tr>
                                @endforelse
                            @else
                                <tr>
                                    <td colspan="5" style="text-align: center;">Aucune Verset enregistrée!</td>
                                </tr>
                            @endif
                        </tbody>
                    </table>
                </div>
                @if ($verses->hasPages())
                    <div class="card-footer clearfix">
                        <ul class="pagination pagination-sm m-0 float-right">
                            <li class="page-item">
                                <a class="btn btn-default btn-sm {{ $verses->onFirstPage() ? 'disabled' : null }}"
                                    href="{{ $verses->previousPageUrl() }}">&laquo;</a>
                            </li>
                            <li class="page-item">
                                <a href="{{ $verses->nextPageUrl() }}"
                                    class="btn btn-default btn-sm {{ !$verses->hasMorePages() ? 'disabled' : null }}">&raquo;</a>
                            </li>
                        </ul>
                    </div>
                @endif
            </div>
        </div>
        <div class="col-md-4">
            <div class="card mb-3">
                <div class="card-header card-outline card-primary">
                    <h3 class="card-title">
                        Image arrière plan
                    </h3>
                </div>
                @if ($verse_image)
                    <div class="card-body text-center p-0">
                        <img class="img-thumbnail w-100"
                            src="{{ asset('storage/verses/images/' . $verse_image->image . '') }}"
                            alt="{{ $verse_image->slug }}">
                    </div>
                    <div class="card-footer text-right">
                        <a href="{{ route('bg.image.delete', $verse_image) }}" class="btn btn-link">
                            <i class="fas fa-trash-alt text-danger"></i>
                        </a>
                    </div>
                @else
                    <form enctype="multipart/form-data" role="form" method="POST"
                        action="{{ route('bg.image.store') }}">
                        @csrf
                        <div class="card-body">
                            <div class="form-group">
                                <div class="input-group">
                                    <div class="custom-file">
                                        <input type="file" class="custom-file-input" id="image" name="image"
                                            accept="image/*">
                                        <label class="custom-file-label" for="image">Choisir image</label>
                                    </div>
                                </div>
                            </div>

                        </div>
                        <div class="card-footer text-right">
                            <button name="submit" type="submit" class="btn btn-primary">
                                <i class="fas fa-save mr-2"></i>
                                Enregistrer
                            </button>
                        </div>
                    </form>
                @endif
            </div>
        </div>
    </div>

    {{--  ADD VERSE MODAL --}}
    <form enctype="multipart/form-data" action="{{ route('verses.store') }}" method="POST">
        @csrf
        <div class="modal fade" id="verseStoreModal" tabindex="-1" aria-labelledby="verseStoreModalLabel"
            aria-hidden="true">
            <div class="modal-dialog">
                <div class="modal-content">
                    <div class="modal-header">
                        <h5 class="modal-title" id="verseStoreModalLabel">AJOUTER ACTIVITE</h5>
                        <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                            <span aria-hidden="true">&times;</span>
                        </button>
                    </div>
                    <div class="modal-body">
                        <div class="row">
                            <div class="col-md-12">
                                <div class="form-group">
                                    <label for="name">Verset <span class="text-danger">*</span></label>
                                    <input type="text" name="name" class="form-control" id="name"
                                        value="{{ old('name') }}" placeholder="Mt. 12:14" required>
                                </div>
                            </div>
                        </div>
                        <div class="row">
                            <div class="col-sm-6">
                                <div class="form-group">
                                    <label>Verset <span class="text-danger">*</span></label>
                                    <div class="input-group">
                                        <div class="input-group-prepend">
                                            <span class="input-group-text"><i class="far fa-calendar-alt"></i></span>
                                        </div>
                                        <input type="date" name="start_date" id="start_date" class="form-control"
                                            placeholder="dd-mm-yyyy" value="{{ old('start_date') }}" required>
                                        @error('start_date')
                                            <span class="small text-danger" role="alert">{{ $message }}</span>
                                        @enderror
                                    </div>
                                </div>
                            </div>
                        </div>
                        <div class="row">
                            <div class="col-md-12">
                                <div class="form-group">
                                    <label for="description">Méditation</label>
                                    <textarea class="form-control" id="description" name="description"
                                        placeholder="Faîtes une description détaillée de l' Verset" style="width: 100%; height: 200px;"></textarea>
                                </div>
                            </div>
                        </div>
                        <div class="row">
                            <div class="col-md-12">
                                <div class="form-group">
                                    <label for="image">Image <span class="text-danger">*</span></label>
                                    <div class="input-group">
                                        <div class="custom-file">
                                            <input value="{{ old('image') }}" type="file" class="custom-file-input"
                                                name="image" id="image" accept="image/*">
                                            <label class="custom-file-label" for="image">Choisir image</label>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <div class="row">
                            <div class="col-md-4">
                                <div class="card mb-3">
                                    <div class="card-body text-center p-0">
                                        <img class="img-thumbnail w-100" id="verse_img" src="#" alt="Image">
                                    </div>
                                </div>
                            </div>
                        </div>
                        <div class="modal-footer">
                            <button type="button" class="btn btn-secondary" data-dismiss="modal">Annuler</button>
                            <button type="submit" class="btn btn-primary">
                                <i class="fas fa-save mr-2"></i>
                                Enregistrer
                            </button>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </form>

@endsection
@section('scripts')
    @include('partials._ckeditor')
    <script src="{{ asset('theme/plugins/bs-custom-file-input/bs-custom-file-input.min.js') }}"></script>
    <script>
        $(function() {
            bsCustomFileInput.init();
        });
    </script>
    <script type="text/javascript">
        function readURL(input) {
            if (input.files && input.files[0]) {
                var reader = new FileReader();

                reader.onload = function(e) {
                    $('#verse_img').attr('src', e.target.result);
                }

                reader.readAsDataURL(input.files[0]);
            }
        }

        $("#image").change(function() {
            readURL(this);
        });
    </script>
@endsection
