@extends('layouts.default', ['current' => 'welcome'])
@section('page_title', 'welcome')
@section('breadcrumb')
    <div class="content-header">
        <div class="container-fluid">
            <div class="row justify-content-end mb-2">
                <div class="col-sm-6">
                    <ol class="breadcrumb float-sm-right">
                        <li class="breadcrumb-item"><a href="{{ route('dashboard') }}">Dashboard</a></li>
                        <li class="breadcrumb-item active">Page d'acceuil text</li>
                    </ol>
                </div>
            </div>
        </div>
    </div>
@endsection
@section('content')
    <div class="row">
        <div class="col-12">
            <div class="card">
                <div class="card-header">
                    <h2 class="card-title">Welcome Text</h2>
                        @if($welcomes->count() < 1)
                        <div class="card-tools">
                            <button type="button" class="btn btn-primary" data-toggle="modal"
                                data-target="#welcomeStoreModal">
                                <i class="fas fa-plus mr-2"></i>
                                Ajouter
                            </button>
                        </div>
                        @endif
                    </div>
                </div>
                <div class="card-header">
                    <div class="row justify-content-end">
                        <div class="col-md-2">
                            <div class="input-group input-group-sm">
                                <input type="text" name="table_search" class="form-control float-right"
                                       placeholder="Search">
                                <div class="input-group-append">
                                    <button type="submit" class="btn btn-default">
                                        <i class="fas fa-search"></i>
                                    </button>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="card-body table-responsive p-0">
                    <table class="table table-hover  table-sm text-nowrap">
                        <thead class="tbl-head bg-dark-light">
                        <tr>
                            <th style="width: 5%;">#</th>
                            <th style="min-width: 30%;">Image</th>
                            <th>Video link</th>
                            <th style="width: 10%;"></th>
                        </tr>
                        </thead>
                        <tbody>
                        @if($welcomes->isNotEmpty())
                            @forelse($welcomes as $welcome)
                                <tr>
                                    <td>{{ $loop->iteration }}.</td>
                                    <td>
                                        <a href="{{ route('welcome.edit', ['welcome' => $welcome]) }}">
                                            @if ($welcome->image)
                                                <img class="mr-2"
                                                     src="{{ asset('storage/welcomes/' . $welcome->image . '') }}"
                                                     style="height: 24px; width: 24px; object-fit: cover; object-position: center"
                                                     alt="{{ $welcome->slug }}">
                                            @endif
                                        </a>
                                    </td>
                                    <td>
                                        <a href="{{ $welcome->video_link }}" target="blank">
                                            <span>{{ $welcome->video_link }}</span>
                                        </a>
                                    </td>
                                    <td class="d-flex justify-content-end">
                                        <a href="{{ route('welcome.edit', $welcome) }}">
                                            <i class="fas mr-2 fa-edit text-warning" title="Modifier"></i>
                                        </a>
                                    </td>
                                </tr>
                            @empty
                                <tr>
                                    <td colspan="4" style="text-align: center;">Aucune information enregistrée!</td>
                                </tr>
                            @endforelse
                        @else    
                            <tr>
                                <td colspan="4" style="text-align: center;">Aucune information enregistrée!</td>
                            </tr>
                        @endif
                        </tbody>
                    </table>
                </div>
            </div>
        </div>
    </div>

    {{--  ADD welcome MODAL --}}
    <form enctype="multipart/form-data" action="{{ route('welcome.store') }}" method="POST">
        @csrf
        <div class="modal fade" id="welcomeStoreModal" tabindex="-1" aria-labelledby="welcomeStoreModalLabel"
             aria-hidden="true">
            <div class="modal-dialog">
                <div class="modal-content">
                    <div class="modal-header">
                        <h5 class="modal-title" id="welcomeStoreModalLabel">AJOUTER </h5>
                        <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                            <span aria-hidden="true">&times;</span>
                        </button>
                    </div>
                    <div class="modal-body">
                        <div class="row">
                            <div class="col-md-12">
                                <div class="form-group">
                                    <label for="video_link">Video link <span class="text-danger">*</span></label>
                                    <input type="text" name="video_link" class="form-control" id="video_link"
                                           value="{{ old('video_link') }}" placeholder="Ex. Chantre" required>
                                </div>
                            </div>
                        </div>
                        <div class="row">
                            <div class="col-md-12">
                                <div class="form-group">
                                    <label for="description">Welcome Text</label>
                                    <textarea class="form-control" id="description" name="description"
                                              placeholder="Faîtes une description détaillée de l' activité"
                                              style="width: 100%; height: 200px;"></textarea>
                                </div>
                            </div>
                        </div>
                        <div class="row">
                            <div class="col-md-12">
                                <div class="form-group">
                                    <label for="image">Image <span class="text-danger">*</span></label>
                                    <div class="input-group">
                                        <div class="custom-file">
                                            <input value="{{ old('image') }}" type="file" class="custom-file-input" name="image" id="image"
                                                   accept="image/*">
                                            <label class="custom-file-label" for="image">Choisir image</label>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <div class="row">
                            <div class="col-md-4">
                                <div class="card mb-3">
                                    <div class="card-body text-center p-0">
                                        <img class="img-thumbnail w-100" id="welcome_img" src="#" alt="Image">
                                    </div>
                                </div>
                            </div>
                        </div>
                        <div class="modal-footer">
                            <button type="button" class="btn btn-secondary" data-dismiss="modal">Annuler</button>
                            <button type="submit" class="btn btn-primary">
                                <i class="fas fa-save mr-2"></i>
                                Enregistrer
                            </button>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </form>

@endsection
@section('scripts')
@include('partials._ckeditor')
    <script src="{{asset('theme/plugins/bs-custom-file-input/bs-custom-file-input.min.js')}}"></script>
    <script>
        $(function () {
            bsCustomFileInput.init();
        });
    </script>
    <script type="text/javascript">
        function readURL(input) {
            if (input.files && input.files[0]) {
                var reader = new FileReader();

                reader.onload = function (e) {
                    $('#welcome_img').attr('src', e.target.result);
                }

                reader.readAsDataURL(input.files[0]);
            }
        }

        $("#image").change(function(){
            readURL(this);
        });
    </script>
@endsection
