<?php

use App\Http\Controllers\AboutController;
use App\Http\Controllers\ActivityController;
use App\Http\Controllers\ContactController;
use App\Http\Controllers\DashboardController;
use App\Http\Controllers\FrontendController;
use App\Http\Controllers\GalleryController;
use App\Http\Controllers\SettingsController;
use App\Http\Controllers\SliderController;
use App\Http\Controllers\SubscriptionController;
use App\Http\Controllers\TeamController;
use App\Http\Controllers\TestimonyController;
use App\Http\Controllers\UserController;
use App\Http\Controllers\VerseController;
use App\Http\Controllers\VerseimageController;
use App\Http\Controllers\WelcomeController;
use Illuminate\Support\Facades\Route;

/*
|--------------------------------------------------------------------------
| Web Routes
|--------------------------------------------------------------------------
|
| Here is where you can register web routes for your application. These
| routes are loaded by the RouteServiceProvider within a group which
| contains the "web" middleware group. Now create something great!
|
 */

Route::get('/', [FrontendController::class, 'index'])->name('index');
Route::get('/about', [FrontendController::class, 'about'])->name('about');
Route::get('/activities/all', [FrontendController::class, 'activities'])->name('front.activities');
Route::get('/activities/all/{activity}', [FrontendController::class, 'activity_show'])->name('activity.show');
Route::get('/contact', [FrontendController::class, 'contact'])->name('contact');
Route::post('/send/mail', [FrontendController::class, 'sendMail'])->name('send.mail');
Route::post('/subscribe', [FrontendController::class, 'subscribe'])->name('subscribe');

Route::get('/optimize', function () {
    \Illuminate\Support\Facades\Artisan::call('optimize');
});

Route::middleware('auth')->group(function () {

    Route::get('/dashboard', [DashboardController::class, 'index'])->name('dashboard');
    Route::resource("abouts", AboutController::class);
    Route::controller(AboutController::class)->group(function () {
        Route::get('abouts/{about}/delete-image', 'deleteImage')->name('abouts.image.delete');
        Route::post('abouts/{about}/add-image', 'addImage')->name('abouts.image.store');
    });

    Route::resource("activities", ActivityController::class);
    Route::post('/store/image/{activity}', [ActivityController::class, 'store_image'])->name('store.image');
    Route::get('/delete/image/{image}', [ActivityController::class, 'delete_image'])->name('delete.image');
    Route::resource("testimonies", TestimonyController::class);
    Route::controller(TestimonyController::class)->group(function () {
        Route::get('testimonies/{testimony}/deleteTestimony-image', 'deleteImage')->name('testimonies.image.delete');
        Route::post('testimonies/{testimony}/addTestimony-image', 'addImage')->name('testimonies.image.store');
    });
    Route::resource("sliders", SliderController::class);
    Route::controller(SliderController::class)->group(function () {
        Route::get('sliders/{slider}/deleteSlider-image', 'deleteImage')->name('sliders.image.delete');
        Route::post('sliders/{slider}/addSlider-image', 'addImage')->name('sliders.image.store');
    });
    Route::resource("teams", TeamController::class);
    Route::controller(TeamController::class)->group(function () {
        Route::get('teams/{team}/deleteTeam-image', 'deleteImage')->name('teams.image.delete');
        Route::post('teams/{team}/addTeam-image', 'addImage')->name('teams.image.store');
    });
    Route::resource("galleries", GalleryController::class);
    Route::controller(GalleryController::class)->group(function () {
        Route::get('galleries/{gallery}/deleteGallery-image', 'deleteImage')->name('galleries.image.delete');
        Route::post('galleries/{gallery}/addGallery-image', 'addImage')->name('galleries.image.store');
    });

    Route::controller(VerseimageController::class)->group(function () {
        Route::post('verse/image/store', 'store')->name('bg.image.store');
        Route::get('verse/image/delete/{verseimage}', 'delete_image')->name('bg.image.delete');
    });

    Route::resource("contacts", ContactController::class);
    Route::resource("subscriptions", SubscriptionController::class);
    Route::controller(SubscriptionController::class)->group(function () {
        Route::get('subscriptions/{subscription}/sendEmail', 'sendEmail')->name('subscriptions.sendEmail');
    });
    Route::resource("verses", VerseController::class);
    Route::controller(VerseController::class)->group(function () {
        Route::get('verses/{verse}/deleteVerse-image', 'deleteImage')->name('verses.image.delete');
        Route::post('verses/{verse}/addVerse-image', 'addImage')->name('verses.image.store');
    });
    Route::resource("settings", SettingsController::class);
    Route::resource("welcome", WelcomeController::class);
    Route::controller(WelcomeController::class)->group(function () {
        Route::get('welcomes/{welcome}/deleteWelcome-image', 'deleteImage')->name('welcome.image.delete');
        Route::post('welcomes/{welcome}/addWelcome-image', 'addImage')->name('welcome.image.store');
    });

    Route::get('/profile', [UserController::class, 'profile'])->name('profile');
    Route::post('/profile/update', [UserController::class, 'update'])->name('profile.update');

});

require __DIR__ . '/auth.php';
