
<?php $__env->startSection('page_title', 'Qui sommes-nous?'); ?>
<?php $__env->startSection('breadcrumb'); ?>
    <div class="content-header">
        <div class="container-fluid">
            <div class="row justify-content-end mb-2">
                <div class="col-sm-6">
                    <ol class="breadcrumb float-sm-right">
                        <li class="breadcrumb-item"><a href="<?php echo e(route('dashboard')); ?>">Dashboard</a></li>
                        <li class="breadcrumb-item active">About</li>
                    </ol>
                </div>
            </div>
        </div>
    </div>
<?php $__env->stopSection(); ?>
<?php $__env->startSection('content'); ?>
    <div class="row">
        <div class="col-12">
            <div class="card">
                <div class="card-header">
                    <h2 class="card-title">About</h2>
                    <div class="card-tools">
                        <button type="button" class="btn btn-primary" data-toggle="modal"
                                data-target="#aboutStoreModal">
                            <i class="fas fa-plus mr-2"></i>
                            Ajouter
                        </button>
                    </div>
                </div>
                <div class="card-header">
                    <div class="row justify-content-end">
                        <div class="col-md-2">
                            <div class="input-group input-group-sm">
                                <input type="text" name="table_search" class="form-control float-right"
                                       placeholder="Search">
                                <div class="input-group-append">
                                    <button type="submit" class="btn btn-default">
                                        <i class="fas fa-search"></i>
                                    </button>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="card-body table-responsive p-0">
                    <table class="table table-hover  table-sm text-nowrap">
                        <thead class="tbl-head bg-dark-light">
                        <tr>
                            <th style="width: 5%;">#</th>
                            <th style="min-width: 30%;">Titre</th>
                            <th style="width: 10%;"></th>
                        </tr>
                        </thead>
                        <tbody>
                        <?php if($abouts->isNotEmpty()): ?>
                            <?php $__empty_1 = true; $__currentLoopData = $abouts; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $about): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                                <tr>
                                    <td><?php echo e($loop->iteration); ?>.</td>
                                    <td>
                                        <a href="<?php echo e(route('abouts.edit', ['about' => $about])); ?>">
                                            <?php if($about->image): ?>
                                                <img class="mr-2"
                                                     src="<?php echo e(asset('storage/abouts/' . $about->image . '')); ?>"
                                                     style="height: 24px; width: 24px; object-fit: cover; object-position: center"
                                                     alt="<?php echo e($about->slug); ?>">
                                            <?php endif; ?>
                                            <span>About</span>
                                        </a>
                                    </td>
                                    <td class="d-flex justify-content-end">
                                        <a href="<?php echo e(route('abouts.edit', $about)); ?>">
                                            <i class="fas mr-2 fa-edit text-warning" title="Modifier"></i>
                                        </a>
                                    </td>
                                </tr>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                                <tr>
                                    <td colspan="5" style="text-align: center;">Aucune donnée enregistrée!</td>
                                </tr>
                            <?php endif; ?>
                        <?php else: ?>    
                            <tr>
                                <td colspan="5" style="text-align: center;">Aucune donnée enregistrée!</td>
                            </tr>
                        <?php endif; ?>
                        </tbody>
                    </table>
                </div>
            </div>
        </div>
    </div>

    
    <form enctype="multipart/form-data" action="<?php echo e(route('abouts.store')); ?>" method="POST">
        <?php echo csrf_field(); ?>
        <div class="modal fade" id="aboutStoreModal" tabindex="-1" aria-labelledby="aboutStoreModalLabel"
             aria-hidden="true">
            <div class="modal-dialog">
                <div class="modal-content">
                    <div class="modal-header">
                        <h5 class="modal-title" id="aboutStoreModalLabel">AJOUTER ABOUT</h5>
                        <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                            <span aria-hidden="true">&times;</span>
                        </button>
                    </div>
                    <div class="modal-body">
                        <div class="row">
                            <div class="col-md-12">
                                <div class="form-group">
                                    <label for="about_text">Qui sommes-nous texte</label>
                                    <textarea class="form-control" id="about_text" name="about_text"
                                              placeholder="Qui sommes-nous texte..."
                                              style="width: 100%; height: 200px;"></textarea>
                                </div>
                            </div>
                        </div>
                        <div class="row">
                            <div class="col-md-12">
                                <div class="form-group">
                                    <label for="objective">Objectif</label>
                                    <textarea class="form-control" id="objective" name="objective"
                                              placeholder="Objectif..."
                                              style="width: 100%; height: 200px;"></textarea>
                                </div>
                            </div>
                        </div>
                        <div class="row">
                            <div class="col-md-12">
                                <div class="form-group">
                                    <label for="mandat">Mandat</label>
                                    <textarea class="form-control" id="mandat" name="mandat"
                                              placeholder="Mandat..."
                                              style="width: 100%; height: 200px;"></textarea>
                                </div>
                            </div>
                        </div>
                        <div class="row">
                            <div class="col-md-12">
                                <div class="form-group">
                                    <label for="goal">But</label>
                                    <textarea class="form-control" id="goal" name="goal"
                                              placeholder="BUT..."
                                              style="width: 100%; height: 200px;"></textarea>
                                </div>
                            </div>
                        </div>
                        <div class="row">
                            <div class="col-md-12">
                                <div class="form-group">
                                    <label for="mission">Mission</label>
                                    <textarea class="form-control" id="mission" name="mission"
                                              placeholder="Mission..."
                                              style="width: 100%; height: 200px;"></textarea>
                                </div>
                            </div>
                        </div>
                        <div class="row">
                            <div class="col-md-12">
                                <div class="form-group">
                                    <label for="image">Image <span class="text-danger">*</span></label>
                                    <div class="input-group">
                                        <div class="custom-file">
                                            <input value="<?php echo e(old('image')); ?>" type="file" class="custom-file-input" name="image" id="image"
                                                   accept="image/*">
                                            <label class="custom-file-label" for="image">Choisir image</label>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <div class="row">
                            <div class="col-md-4">
                                <div class="card mb-3">
                                    <div class="card-body text-center p-0">
                                        <img class="img-thumbnail w-100" id="about_img" src="#" alt="Image">
                                    </div>
                                </div>
                            </div>
                        </div>
                        <div class="modal-footer">
                            <button type="button" class="btn btn-secondary" data-dismiss="modal">Annuler</button>
                            <button type="submit" class="btn btn-primary">
                                <i class="fas fa-save mr-2"></i>
                                Enregistrer
                            </button>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </form>

<?php $__env->stopSection(); ?>
<?php $__env->startSection('scripts'); ?>
    <script src="https://cdn.ckeditor.com/ckeditor5/23.0.0/classic/ckeditor.js"></script>
    <script>
        ClassicEditor
            .create(document.querySelector('#mission'), {
                removePlugins: ['CKFinderUploadAdapter', 'CKFinder', 'EasyImage', 'Image', 'ImageCaption', 'ImageStyle', 'ImageToolbar', 'ImageUpload', 'MediaEmbed'],
            })
            .catch( error => {
                console.error( error );
            });
            ClassicEditor
            .create(document.querySelector('#objective'), {
                removePlugins: ['CKFinderUploadAdapter', 'CKFinder', 'EasyImage', 'Image', 'ImageCaption', 'ImageStyle', 'ImageToolbar', 'ImageUpload', 'MediaEmbed'],
            })
            .catch( error => {
                console.error( error );
            });
            ClassicEditor
            .create(document.querySelector('#goal'), {
                removePlugins: ['CKFinderUploadAdapter', 'CKFinder', 'EasyImage', 'Image', 'ImageCaption', 'ImageStyle', 'ImageToolbar', 'ImageUpload', 'MediaEmbed'],
            })
            .catch( error => {
                console.error( error );
            });
            ClassicEditor
            .create(document.querySelector('#about_text'), {
                removePlugins: ['CKFinderUploadAdapter', 'CKFinder', 'EasyImage', 'Image', 'ImageCaption', 'ImageStyle', 'ImageToolbar', 'ImageUpload', 'MediaEmbed'],
            })
            .catch( error => {
                console.error( error );
            });
            ClassicEditor
            .create(document.querySelector('#mandat'), {
                removePlugins: ['CKFinderUploadAdapter', 'CKFinder', 'EasyImage', 'Image', 'ImageCaption', 'ImageStyle', 'ImageToolbar', 'ImageUpload', 'MediaEmbed'],
            })
            .catch( error => {
                console.error( error );
            });
    </script>
    <script src="<?php echo e(asset('theme/plugins/bs-custom-file-input/bs-custom-file-input.min.js')); ?>"></script>
    <script>
        $(function () {
            bsCustomFileInput.init();
        });
    </script>
    <script type="text/javascript">
        function readURL(input) {
            if (input.files && input.files[0]) {
                var reader = new FileReader();

                reader.onload = function (e) {
                    $('#about_img').attr('src', e.target.result);
                }

                reader.readAsDataURL(input.files[0]);
            }
        }

        $("#image").change(function(){
            readURL(this);
        });
    </script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.default', ['current' => 'about'], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\xampp\htdocs\peter-ministries\JBC\peter-ministries\resources\views/about/index.blade.php ENDPATH**/ ?>