
<?php $__env->startSection('page_title', 'Versets'); ?>
<?php $__env->startSection('breadcrumb'); ?>
    <div class="content-header">
        <div class="container-fluid">
            <div class="row justify-content-end mb-2">
                <div class="col-sm-6">
                    <ol class="breadcrumb float-sm-right">
                        <li class="breadcrumb-item"><a href="<?php echo e(route('dashboard')); ?>">Dashboard</a></li>
                        <li class="breadcrumb-item active">Versets</li>
                    </ol>
                </div>
            </div>
        </div>
    </div>
<?php $__env->stopSection(); ?>
<?php $__env->startSection('content'); ?>
    <div class="row">
        <div class="col-8">
            <div class="card">
                <div class="card-header">
                    <h2 class="card-title">Versets</h2>
                    <div class="card-tools">
                        <button type="button" class="btn btn-primary" data-toggle="modal" data-target="#verseStoreModal">
                            <i class="fas fa-plus mr-2"></i>
                            Ajouter Verset
                        </button>
                    </div>
                </div>
                <div class="card-header">
                    <div class="row justify-content-end">
                        <div class="col-md-2">
                            <div class="input-group input-group-sm">
                                <input type="text" name="table_search" class="form-control float-right"
                                    placeholder="Search">
                                <div class="input-group-append">
                                    <button type="submit" class="btn btn-default">
                                        <i class="fas fa-search"></i>
                                    </button>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="card-body table-responsive p-0">
                    <table class="table table-hover  table-sm text-nowrap">
                        <thead class="tbl-head bg-dark-light">
                            <tr>
                                <th style="width: 5%;">#</th>
                                <th style="min-width: 30%;">verset</th>
                                <th>Date</th>
                                <th style="width: 10%;"></th>
                            </tr>
                        </thead>
                        <tbody>
                            <?php if($verses->isNotEmpty()): ?>
                                <?php $__empty_1 = true; $__currentLoopData = $verses; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $verse): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                                    <tr>
                                        <td><?php echo e($loop->iteration); ?>.</td>
                                        <td>
                                            <a href="<?php echo e(route('verses.edit', ['verse' => $verse])); ?>">
                                                <?php if($verse->image): ?>
                                                    <img class="mr-2"
                                                        src="<?php echo e(asset('storage/verses/' . $verse->image . '')); ?>"
                                                        style="height: 24px; width: 24px; object-fit: cover; object-position: center"
                                                        alt="<?php echo e($verse->verse); ?>">
                                                <?php endif; ?>
                                                <span><?php echo e($verse->title); ?></span>
                                            </a>
                                        </td>
                                        <td>
                                            <?php echo e(Carbon\Carbon::parse($verse->date)->format('d-m-Y')); ?>

                                        </td>
                                        <td class="d-flex justify-content-end">
                                            <a href="<?php echo e(route('verses.edit', $verse)); ?>">
                                                <i class="fas mr-2 fa-edit text-warning" title="Modifier"></i>
                                            </a>
                                        </td>
                                    </tr>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                                    <tr>
                                        <td colspan="5" style="text-align: center;">Aucune Verset enregistrée!</td>
                                    </tr>
                                <?php endif; ?>
                            <?php else: ?>
                                <tr>
                                    <td colspan="5" style="text-align: center;">Aucune Verset enregistrée!</td>
                                </tr>
                            <?php endif; ?>
                        </tbody>
                    </table>
                </div>
                <?php if($verses->hasPages()): ?>
                    <div class="card-footer clearfix">
                        <ul class="pagination pagination-sm m-0 float-right">
                            <li class="page-item">
                                <a class="btn btn-default btn-sm <?php echo e($verses->onFirstPage() ? 'disabled' : null); ?>"
                                    href="<?php echo e($verses->previousPageUrl()); ?>">&laquo;</a>
                            </li>
                            <li class="page-item">
                                <a href="<?php echo e($verses->nextPageUrl()); ?>"
                                    class="btn btn-default btn-sm <?php echo e(!$verses->hasMorePages() ? 'disabled' : null); ?>">&raquo;</a>
                            </li>
                        </ul>
                    </div>
                <?php endif; ?>
            </div>
        </div>
        <div class="col-md-4">
            <div class="card mb-3">
                <div class="card-header card-outline card-primary">
                    <h3 class="card-title">
                        Image arrière plan
                    </h3>
                </div>
                <?php if($verse_image): ?>
                    <div class="card-body text-center p-0">
                        <img class="img-thumbnail w-100"
                            src="<?php echo e(asset('storage/verses/images/' . $verse_image->image . '')); ?>"
                            alt="<?php echo e($verse_image->slug); ?>">
                    </div>
                    <div class="card-footer text-right">
                        <a href="<?php echo e(route('bg.image.delete', $verse_image)); ?>" class="btn btn-link">
                            <i class="fas fa-trash-alt text-danger"></i>
                        </a>
                    </div>
                <?php else: ?>
                    <form enctype="multipart/form-data" role="form" method="POST"
                        action="<?php echo e(route('bg.image.store')); ?>">
                        <?php echo csrf_field(); ?>
                        <div class="card-body">
                            <div class="form-group">
                                <div class="input-group">
                                    <div class="custom-file">
                                        <input type="file" class="custom-file-input" id="image" name="image"
                                            accept="image/*">
                                        <label class="custom-file-label" for="image">Choisir image</label>
                                    </div>
                                </div>
                            </div>

                        </div>
                        <div class="card-footer text-right">
                            <button name="submit" type="submit" class="btn btn-primary">
                                <i class="fas fa-save mr-2"></i>
                                Enregistrer
                            </button>
                        </div>
                    </form>
                <?php endif; ?>
            </div>
        </div>
    </div>

    
    <form enctype="multipart/form-data" action="<?php echo e(route('verses.store')); ?>" method="POST">
        <?php echo csrf_field(); ?>
        <div class="modal fade" id="verseStoreModal" tabindex="-1" aria-labelledby="verseStoreModalLabel"
            aria-hidden="true">
            <div class="modal-dialog">
                <div class="modal-content">
                    <div class="modal-header">
                        <h5 class="modal-title" id="verseStoreModalLabel">AJOUTER ACTIVITE</h5>
                        <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                            <span aria-hidden="true">&times;</span>
                        </button>
                    </div>
                    <div class="modal-body">
                        <div class="row">
                            <div class="col-md-12">
                                <div class="form-group">
                                    <label for="name">Verset <span class="text-danger">*</span></label>
                                    <input type="text" name="name" class="form-control" id="name"
                                        value="<?php echo e(old('name')); ?>" placeholder="Mt. 12:14" required>
                                </div>
                            </div>
                        </div>
                        <div class="row">
                            <div class="col-sm-6">
                                <div class="form-group">
                                    <label>Verset <span class="text-danger">*</span></label>
                                    <div class="input-group">
                                        <div class="input-group-prepend">
                                            <span class="input-group-text"><i class="far fa-calendar-alt"></i></span>
                                        </div>
                                        <input type="date" name="start_date" id="start_date" class="form-control"
                                            placeholder="dd-mm-yyyy" value="<?php echo e(old('start_date')); ?>" required>
                                        <?php $__errorArgs = ['start_date'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                            <span class="small text-danger" role="alert"><?php echo e($message); ?></span>
                                        <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <div class="row">
                            <div class="col-md-12">
                                <div class="form-group">
                                    <label for="description">Méditation</label>
                                    <textarea class="form-control" id="description" name="description"
                                        placeholder="Faîtes une description détaillée de l' Verset" style="width: 100%; height: 200px;"></textarea>
                                </div>
                            </div>
                        </div>
                        <div class="row">
                            <div class="col-md-12">
                                <div class="form-group">
                                    <label for="image">Image <span class="text-danger">*</span></label>
                                    <div class="input-group">
                                        <div class="custom-file">
                                            <input value="<?php echo e(old('image')); ?>" type="file" class="custom-file-input"
                                                name="image" id="image" accept="image/*">
                                            <label class="custom-file-label" for="image">Choisir image</label>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <div class="row">
                            <div class="col-md-4">
                                <div class="card mb-3">
                                    <div class="card-body text-center p-0">
                                        <img class="img-thumbnail w-100" id="verse_img" src="#" alt="Image">
                                    </div>
                                </div>
                            </div>
                        </div>
                        <div class="modal-footer">
                            <button type="button" class="btn btn-secondary" data-dismiss="modal">Annuler</button>
                            <button type="submit" class="btn btn-primary">
                                <i class="fas fa-save mr-2"></i>
                                Enregistrer
                            </button>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </form>

<?php $__env->stopSection(); ?>
<?php $__env->startSection('scripts'); ?>
    <?php echo $__env->make('partials._ckeditor', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
    <script src="<?php echo e(asset('theme/plugins/bs-custom-file-input/bs-custom-file-input.min.js')); ?>"></script>
    <script>
        $(function() {
            bsCustomFileInput.init();
        });
    </script>
    <script type="text/javascript">
        function readURL(input) {
            if (input.files && input.files[0]) {
                var reader = new FileReader();

                reader.onload = function(e) {
                    $('#verse_img').attr('src', e.target.result);
                }

                reader.readAsDataURL(input.files[0]);
            }
        }

        $("#image").change(function() {
            readURL(this);
        });
    </script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.default', ['current' => 'verses'], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\xampp\htdocs\peter-ministries\JBC\peter-ministries\resources\views/verses/index.blade.php ENDPATH**/ ?>