<?php
    $auth = Auth::user();
?>
<aside class="main-sidebar sidebar-dark-primary elevation-4">
    <a class="brand-link">
        <img src="<?php echo e(asset('img/logo.png')); ?>" alt="PeterMinistries-Logo" class="brand-image img-circle elevation-3"
            style="opacity: .8; object-fit: cover;">
        <span class="brand-text font-weight-light"><?php echo e(config('app.name')); ?></span>
    </a>
    <div class="sidebar">
        <div class="user-panel mt-3 pb-3 mb-3 d-flex">
            <div class="image">
                <?php if($auth->image): ?>
                    <img class="nav-icon" src="<?php echo e(asset('storage/users/' . $auth->image . '')); ?>"
                        alt="<?php echo e($auth->slug); ?>">
                <?php else: ?>
                    <img type="image/png" class="nav-icon" src="<?php echo e(asset('img/icons/icons8-user-50-black.png')); ?>"
                        alt="User Image">
                <?php endif; ?>
            </div>
            <div class="info">
                <a href="<?php echo e(route('profile')); ?>" class="d-block"><?php echo e($auth->name); ?></a>
            </div>
        </div>
        <nav class="mt-2">
            <ul class="nav nav-pills nav-sidebar flex-column" data-widget="treeview" role="menu"
                data-accordion="false">
                <li class="nav-item">
                    <a href="<?php echo e(route('dashboard')); ?>" class="nav-link <?php echo e($current == 'dashboard' ? 'active' : null); ?>">
                        <img type="image/png" class="nav-icon" src="<?php echo e(asset('img/icons/icons8-vitesse-50.png')); ?>">
                        <p>
                            Dashboard
                        </p>
                    </a>
                </li>
                <li class="nav-item">
                    <a href="<?php echo e(route('abouts.index')); ?>"
                        class="nav-link <?php echo e($current == 'about' ? 'active' : null); ?>">
                        <img type="image/png" class="nav-icon"
                            src="<?php echo e(asset('img/icons/icons8-product-management-50.png')); ?>">
                        <p>
                            About
                        </p>
                    </a>
                </li>
                <li class="nav-item">
                    <a href="<?php echo e(route('activities.index')); ?>"
                        class="nav-link <?php echo e($current == 'activities' ? 'active' : null); ?>">
                        <img type="image/png" class="nav-icon"
                            src="<?php echo e(asset('img/icons/icons8-product-management-50.png')); ?>">
                        <p>
                            Activités
                        </p>
                    </a>
                </li>
                <li class="nav-item">
                    <a href="<?php echo e(route('contacts.index')); ?>"
                        class="nav-link <?php echo e($current == 'contacts' ? 'active' : null); ?>">
                        <img type="image/png" class="nav-icon"
                            src="<?php echo e(asset('img/icons/icons8-search-contacts-50.png')); ?>">
                        <p>
                            Contacts
                        </p>
                    </a>
                </li>
                <li class="nav-item">
                    <a href="<?php echo e(route('galleries.index')); ?>"
                        class="nav-link <?php echo e($current == 'galleries' ? 'active' : null); ?>">
                        <img class="nav-icon" src="<?php echo e(asset('img/icons/icons8-gallery-50.png')); ?>">
                        <p>
                            Galleries
                        </p>
                    </a>
                </li>
                <li class="nav-item">
                    <a href="<?php echo e(route('settings.index')); ?>"
                        class="nav-link <?php echo e($current == 'settings' ? 'active' : null); ?>">
                        <img type="image/png" class="nav-icon"
                            src="<?php echo e(asset('img/icons/icons8-user-groups-50.png')); ?>">
                        <p>
                            Settings
                        </p>
                    </a>
                </li>
                <li class="nav-item">
                    <a href="<?php echo e(route('sliders.index')); ?>"
                        class="nav-link <?php echo e($current == 'sliders' ? 'active' : null); ?>">
                        <img type="image/png" class="nav-icon" src="<?php echo e(asset('img/icons/icons8-gallery-50.png')); ?>">
                        <p>
                            Sliders
                        </p>
                    </a>
                </li>
                <li class="nav-item">
                    <a href="<?php echo e(route('subscriptions.index')); ?>"
                        class="nav-link <?php echo e($current == 'subscriptions' ? 'active' : null); ?>">
                        <img class="nav-icon" src="<?php echo e(asset('img/icons/icons8-photo-gallery-50.png')); ?>">
                        <p>
                            Souscriptions
                        </p>
                    </a>
                </li>
                <li class="nav-item">
                    <a href="<?php echo e(route('teams.index')); ?>" class="nav-link <?php echo e($current == 'teams' ? 'active' : null); ?>">
                        <img type="image/png" class="nav-icon" src="<?php echo e(asset('img/icons/icons8-us-news-50.png')); ?>">
                        <p>
                            Teams
                        </p>
                    </a>
                </li>
                <li class="nav-item">
                    <a href="<?php echo e(route('testimonies.index')); ?>"
                        class="nav-link <?php echo e($current == 'testimonies' ? 'active' : null); ?>">
                        <img type="image/png" class="nav-icon"
                            src="<?php echo e(asset('img/icons/icons8-communication-50.png')); ?>">
                        <p>
                            Témoignages
                        </p>
                    </a>
                </li>
                <li class="nav-item">
                    <a href="<?php echo e(route('verses.index')); ?>"
                        class="nav-link <?php echo e($current == 'verses' ? 'active' : null); ?>">
                        <img class="nav-icon" src="<?php echo e(asset('img/icons/icons8-services-50.png')); ?>">
                        <p>
                            Versets
                        </p>
                    </a>
                </li>
                <li class="nav-item">
                    <a href="<?php echo e(route('welcome.index')); ?>"
                        class="nav-link <?php echo e($current == 'welcome' ? 'active' : null); ?>">
                        <img type="image/png" class="nav-icon"
                            src="<?php echo e(asset('img/icons/icons8-product-management-50.png')); ?>">
                        <p>
                            Welcome
                        </p>
                    </a>
                </li>
                <!-- <li class="nav-item">
                    <a href=""
                       class="nav-link <?php echo e($current == 'profile' ? 'active' : null); ?>">
                        <img type="image/png" class="nav-icon" src="<?php echo e(asset('img/icons/icons8-edit-account-50.png')); ?>">
                        <p>
                            Profil
                        </p>
                    </a>
                </li> -->
            </ul>
        </nav>
    </div>
</aside>
<?php /**PATH C:\xampp\htdocs\peter-ministries\JBC\peter-ministries\resources\views/partials/_sidebar.blade.php ENDPATH**/ ?>