<!DOCTYPE html>
<html lang="<?php echo e(str_replace('_', '-', app()->getLocale())); ?>">

<head>
    <title><?php echo e(config('app.name')); ?> | <?php echo $__env->yieldContent('page_title'); ?></title>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1, shrink-to-fit=no">
    <link rel="shortcut icon" href="<?php echo e(asset('/img/pbm.png')); ?>" />
    <link href="https://fonts.googleapis.com/css?family=Open+Sans:300,400,600,700,800&amp;display=swap" rel="stylesheet">
    <link href="https://fonts.googleapis.com/css?family=Lora:400,400i,700,700i&amp;display=swap" rel="stylesheet">
    <link href="https://fonts.googleapis.com/css?family=Great+Vibes&amp;display=swap" rel="stylesheet">
    <link rel="stylesheet" href="https://use.fontawesome.com/releases/v5.15.4/css/all.css">
    <link rel="stylesheet" href="<?php echo e(asset('front_theme/css/open-iconic-bootstrap.min.css ')); ?>">
    <link rel="stylesheet" href="<?php echo e(asset('front_theme/css/animate.css ')); ?>">
    <link rel="stylesheet" href="<?php echo e(asset('front_theme/css/owl.carousel.min.css ')); ?>">
    <link rel="stylesheet" href="<?php echo e(asset('front_theme/css/owl.theme.default.min.css ')); ?>">
    <link rel="stylesheet" href="<?php echo e(asset('front_theme/css/magnific-popup.css ')); ?>">
    <link rel="stylesheet" href="<?php echo e(asset('front_theme/css/aos.css ')); ?>">
    <link rel="stylesheet" href="<?php echo e(asset('front_theme/css/ionicons.min.css ')); ?>">
    <link rel="stylesheet" href="<?php echo e(asset('front_theme/css/flaticon.css ')); ?>">
    <link rel="stylesheet" href="<?php echo e(asset('front_theme/css/icomoon.css ')); ?>">
    <link rel="stylesheet" href="<?php echo e(asset('front_theme/css/style.css ')); ?>">
    <link rel="stylesheet" href="<?php echo e(asset('front_theme/css/custom.css ')); ?>">
    <link rel="stylesheet" type="text/css" href="https://cdn.jsdelivr.net/npm/toastify-js/src/toastify.min.css">

    <?php if(Route::currentRouteName() == 'index'): ?>
        <link rel="stylesheet" href="<?php echo e(asset('front_theme/css/testimony.css ')); ?>">
    <?php endif; ?>
    <style>
        .logo {
            width: 120px;
            object-fit: cover;
        }
    </style>
    <?php echo $__env->yieldContent('addCSS'); ?>
</head>

<body data-spy="scroll" data-target=".site-navbar-target" data-offset="300">
    <?php echo $__env->make('frontend.partials.header', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
    <?php echo $__env->yieldContent('content'); ?>
    <?php echo $__env->make('frontend.partials.footer', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>

    <div id="ftco-loader" class="show fullscreen"><svg class="circular" width="48px" height="48px">
            <circle class="path-bg" cx="24" cy="24" r="22" fill="none" stroke-width="4"
                stroke="#eeeeee" />
            <circle class="path" cx="24" cy="24" r="22" fill="none" stroke-width="4"
                stroke-miterlimit="10" stroke="#F96D00" />
        </svg></div>
    <script src="<?php echo e(asset('front_theme/js/jquery.min.js')); ?>"></script>
    <script src="<?php echo e(asset('front_theme/js/jquery-migrate-3.0.1.min.js')); ?>"></script>
    <script src="<?php echo e(asset('front_theme/js/popper.min.js')); ?>"></script>
    <script src="<?php echo e(asset('front_theme/js/bootstrap.min.js')); ?>"></script>
    <script src="<?php echo e(asset('front_theme/js/jquery.easing.1.3.js')); ?>"></script>
    <script src="<?php echo e(asset('front_theme/js/jquery.waypoints.min.js')); ?>"></script>
    <script src="<?php echo e(asset('front_theme/js/jquery.stellar.min.js')); ?>"></script>
    <script src="<?php echo e(asset('front_theme/js/owl.carousel.min.js')); ?>"></script>
    <script src="<?php echo e(asset('front_theme/js/jquery.magnific-popup.min.js')); ?>"></script>
    <script src="<?php echo e(asset('front_theme/js/aos.js')); ?>"></script>
    <script src="<?php echo e(asset('front_theme/js/jquery.animateNumber.min.js')); ?>"></script>
    <script src="<?php echo e(asset('front_theme/js/scrollax.min.js')); ?>"></script>
    <script src="https://maps.googleapis.com/maps/api/js?key=AIzaSyBVWaKrjvy3MaE7SQ74_uJiULgl1JY0H2s&amp;sensor=false">
    </script>
    <script src="<?php echo e(asset('front_theme/js/google-map.js')); ?>"></script>
    <script src="<?php echo e(asset('front_theme/js/main.js')); ?>"></script>


    <script async src="https://www.googletagmanager.com/gtag/js?id=UA-23581568-13"></script>
    <script type="text/javascript" src="https://cdn.jsdelivr.net/npm/toastify-js"></script>
    <?php echo $__env->make('frontend.partials.notifications', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>

    <?php echo $__env->yieldContent('addJS'); ?>

</body>

</html>
<?php /**PATH C:\xampp\htdocs\peter-ministries\JBC\peter-ministries\resources\views/frontend/layouts/app.blade.php ENDPATH**/ ?>