
<?php $__env->startSection('page_title', 'Accueil'); ?>

<?php $__env->startSection('content'); ?>
    <section class="home-slider js-fullheight owl-carousel">
        <?php $__currentLoopData = $sliders; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $slider): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
            <div class="slider-item js-fullheight"
                style="background-image:url(<?php echo e(asset('storage/sliders/' . $slider->image . '')); ?>);">
                <div class="overlay"></div>
                <div class="container">
                    <div class="row no-gutters slider-text js-fullheight align-items-center justify-content-center"
                        data-scrollax-parent="true">
                        <div class="col-md-8 text-center ftco-animate mt-5">
                            <div class="text">
                                <div class="subheading">
                                    <span>Peter Byamungu Ministries</span>
                                </div>
                                <h1 class="mb-4"><?php echo e($slider->heading1); ?> <span><?php echo e($slider->heading2); ?></span></h1>
                                <p><?php echo $slider->description; ?></p>
                                <p><a href="<?php echo e(route('about')); ?>" class="btn btn-primary py-2 px-4">A propos</a> <a
                                        href="<?php echo e(route('contact')); ?>"
                                        class="btn btn-primary btn-outline-primary py-2 px-4">Contact</a></p>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
    </section>
    <section class="ftco-section ftco-services-2" id="services-section">
        <div class="container">
            <div class="row justify-content-center pb-5">
                
                <div class="col-md-6 sermon-wrap ftco-animate  img d-flex align-items-center justify-content-center"
                    style="height:350px">
                    <iframe width="100%" height="350"
                        src="https://www.youtube.com/embed/<?php echo e($welcome->video_link); ?>?modestbranding=1&autohide=1&showinfo=0&controls=1"
                        title="YouTube video player" frameborder="0"
                        allow="accelerometer; autoplay; clipboard-write; encrypted-media; gyroscope; picture-in-picture; web-share"
                        allowfullscreen></iframe>
                </div>
                <div class="col-md-6 heading-section text-center ftco-animate">
                    <span class="subheading">Bienvenu chez</span>
                    <h2 class="mb-4">Peter Byamungu Ministries</h2>
                    <p><?php echo $welcome->welcome_text; ?></p>
                </div>

            </div>
            <div class="row">
                <div class="col-md d-flex align-self-stretch ftco-animate">
                    <div class="media block-6 services text-center d-block">
                        <div class="icon"><span class="flaticon-praying"></span></div>
                        <div class="media-body">
                            <h3 class="heading mb-3">Mandat</h3>
                            <div class="mandat"
                                data-config='{ "type": "text", "limit": 90, "more": "→ voir plus", "less": "← voir moins" }'>
                                <?php echo $about->mandat; ?>

                            </div>
                        </div>
                    </div>
                </div>
                <div class="col-md d-flex align-self-stretch ftco-animate">
                    <div class="media block-6 services text-center d-block">
                        <div class="icon"><span class="flaticon-bible"></span></div>
                        <div class="media-body">
                            <h3 class="heading mb-3">Objectif</h3>
                            <div class="objective"
                                data-config='{ "type": "text", "limit": 90, "more": "→ voir plus", "less": "← voir moins" }'>
                                <?php echo $about->objective; ?>

                            </div>
                        </div>
                    </div>
                </div>
                <div class="col-md d-flex align-self-stretch ftco-animate">
                    <div class="media block-6 services text-center d-block">
                        <div class="icon"><span class="flaticon-church"></span></div>
                        <div class="media-body">
                            <h3 class="heading mb-3">But</h3>
                            <div class="but"
                                data-config='{ "type": "text", "limit": 90, "more": "→ voir plus", "less": "← voir moins" }'>
                                <?php echo $about->goal; ?>

                            </div>
                        </div>
                    </div>
                </div>
                <div class="col-md d-flex align-self-stretch ftco-animate">
                    <div class="media block-6 services text-center d-block">
                        <div class="icon"><span class="flaticon-social-care"></span></div>
                        <div class="media-body">
                            <h3 class="heading mb-3">Mission</h3>
                            <div class="mission"
                                data-config='{ "type": "text", "limit": 90, "more": "→ voir plus", "less": "← voir moins" }'>
                                <?php echo $about->mission; ?>

                            </div>
                        </div>
                    </div>
                </div>
            </div>
            <div class="row mt-4 justify-content-end">
                <div class="col-lg-10">
                    <div class="donated-intro bg-darken p-4 p-md-5">
                        <h2><span>Faire un don</span></h2>
                        <p>Aujourd’hui, notre mission est d’annoncer l’évangile partout dans le monde par des conférences
                            totalement gratuites, des réunions de couples, des festivals musicaux, des évangélisations en
                            milieux scolaires et universitaire, l’octroi de bourses d’études aux étudiants n’ayant pas le
                            moyen de se prendre en charge, la production des chantres gospels, </p>
                        <p>
                            Donnez ce que le Seigneur vous met sur le cœur 10$, 100$, 500$ ou même 1000$.
                        </p>
                        <ul>
                            <?php if($setting->airtelmoney): ?>
                                <li>airtel Money: <?php echo e($setting->airtelmoney); ?></li>
                            <?php endif; ?>
                            <?php if($setting->mpesa): ?>
                                <li>Mpesa: <?php echo e($setting->mpesa); ?></li>
                            <?php endif; ?>
                            <?php if($setting->orangemoney): ?>
                                <li>airtel Money: <?php echo e($setting->orangemoney); ?></li>
                            <?php endif; ?>
                            <?php if($setting->bankname && $setting->bankaccount): ?>
                                <li>Banque: <?php echo e($setting->bankname . ': ' . $setting->bankaccount); ?></li>
                            <?php endif; ?>
                        </ul>
                        <p>
                            Vous pouvez devenir partenaire mensuel ou donner un seul don ponctuel
                            <a href="<?php echo e(route('contact')); ?>" class="btn btn-black px-4 py-3">Nous contacter!</a>
                        </p>
                    </div>
                </div>
            </div>
        </div>
    </section>

    <?php if($verse): ?>
        <section class="ftco-daily-verse img"
            style="background-image: url(<?php echo e($verse_image ? asset('storage/verses/images/' . $verse_image->image . '') : ''); ?>);">
            <div class="overlay"></div>
            <div class="container">
                <div class="row justify-content-center">
                    <div class="col-md-10">
                        <div class="row justify-content-center align-items-center">
                            <div class="col-md-2 ftco-animate">
                                <div class="icon">
                                    <span class="flaticon-church"></span>
                                </div>
                            </div>
                            <div class="col-md-10 daily-verse pl-md-5 ftco-animate">
                                <span class="subheading">Verset du jour:</span>
                                <h3><?php echo $verse->meditation; ?></h3>
                                <h4 class="h5 mt-4 font-weight-bold"><span>Bible:</span> <?php echo e($verse->verse); ?></h4>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </section>
    <?php endif; ?>

    <?php if($testimonies->isNotEmpty()): ?>
        <section class="ftco-section bg-light" id="sermons-section">
            <div class="container">
                <div class="row justify-content-center pb-5">
                    <div class="col-md-12 heading-section text-center ftco-animate">
                        <span class="subheading">Temoignages</span>
                        <h2 class="mb-4">Quelques Temoignages</h2>
                        <p>Ce que les gens disent de nous</p>
                    </div>
                </div>
                <div class="row">
                    <div id="demo" class="carousel slide" data-ride="carousel">
                        <div class="carousel-inner">
                            <?php $__currentLoopData = $testimonies; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $testimony): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <div class="carousel-item <?php if($loop->first): ?> active <?php endif; ?>">
                                    <div class="carousel-caption">
                                        <p><?php echo $testimony->description; ?>

                                        </p>
                                        <?php if($testimony->image): ?>
                                            <img src="<?php echo e(asset('storage/testimonies/' . $testimony->image . '')); ?>"
                                                alt="<?php echo e($testimony->slug); ?>"
                                                style="height: 84px; width: 84px; object-fit: cover; object-position: center">
                                        <?php else: ?>
                                            <img src="<?php echo e(asset('img/users/unknown.jpg')); ?>"
                                                style="height: 84px; width: 84px; object-fit: cover; object-position: center"
                                                alt="unknown">
                                        <?php endif; ?>
                                        <div id="image-caption"><?php echo e($testimony->title); ?></div>
                                    </div>
                                </div>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </div>
                    </div>
                </div>
            </div>
        </section>
    <?php endif; ?>
    <?php if(getActivities()->isNotEmpty()): ?>
        <section class="ftco-section bg-light" id="sermons-section">
            <div class="container">
                <div class="row justify-content-center pb-5">
                    <div class="col-md-12 heading-section text-center ftco-animate">
                        <span class="subheading">Activités</span>
                        <h2 class="mb-4">Nos Recentes Activités</h2>
                    </div>
                </div>
                <div class="row">
                    <?php $__currentLoopData = getActivities(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $activity): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <div class="col-md-4">
                            <div class="sermon-wrap ftco-animate">
                                <div class="img d-flex align-items-center justify-content-center"
                                    style="background-image: url(<?php echo e($activity->images->isNotEmpty() ? asset('storage/activities/' . $activity->images->first()->image . '') : asset('front_theme/images/image_1.jpg')); ?>);width:349px;height:450px;">
                                    <div class="text-content p-4 text-center">
                                        <p class="">
                                            <a href="<?php echo e(route('activity.show', $activity)); ?>"
                                                class="btn-custom p-2 text-center">
                                                Lire plus</a>
                                        </p>
                                    </div>
                                </div>
                                <div class="text pt-3 text-center">
                                    <h2 class="mb-0"><a
                                            href="<?php echo e(route('activity.show', $activity)); ?>"><?php echo e($activity->title); ?></a>
                                    </h2>
                                    <div class="meta">
                                        <p class="mb-0">
                                            <span><?php echo e(Carbon\Carbon::parse($activity->started_at)->format('d-M-Y')); ?></span>
                                        </p>
                                    </div>
                                </div>
                            </div>
                        </div>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </div>
            </div>
        </section>
    <?php endif; ?>
    <?php if($galleries->isNotEmpty()): ?>
        <div class="row justify-content-center mb-5 pb-3">
            <div class="col-md-7 heading-section ftco-animate text-center">
                <h3 class="subheading">Gallery</h3>
                <h2 class="mb-1">Peter Byamungu Ministries Gallerie Photo</h2>
            </div>
        </div>
        <div class="row">
            <?php $__currentLoopData = $galleries; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $gallery): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                <div class="col-md-3 ftco-animate">
                    <a href="<?php echo e(asset('storage/galleries/' . $gallery->image . '')); ?>"
                        class="gallery image-popup img d-flex align-items-center"
                        style="background-image: url(<?php echo e(asset('storage/galleries/' . $gallery->image . '')); ?>);">
                        <div class="icon mb-4 d-flex align-items-center justify-content-center">
                            <span class="icon-instagram"></span>
                        </div>
                    </a>
                </div>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
        </div>
        </div>
        </section>
    <?php endif; ?>
<?php $__env->stopSection(); ?>
<?php $__env->startSection('addCSS'); ?>
    
    <style>
        /* styling buttons */
        .show-more-btn {
            margin: auto;
            cursor: pointer;
            color: #000;
            white-space: nowrap;
            transition: color 300ms ease-in-out;
            border: 0;
            font-size: 0.8em;
            background: transparent;
        }

        .show-more-btn:hover {
            color: #ffd615;
        }

        .hidden {
            display: none;
        }

        /*owl carousel*/
        .owl-carousel .owl-stage,
        .owl-carousel.owl-drag .owl-item {
            -ms-touch-action: pan-y !important;
            touch-action: pan-y !important;
        }
    </style>
<?php $__env->stopSection(); ?>
<?php $__env->startSection('addJS'); ?>
    <script src="https://cdn.jsdelivr.net/gh/tomik23/show-more@1.1.6/dist/js/showMore.min.js"></script>
    <script>
        (function() {
            new ShowMore('.mandat');
            new ShowMore('.objective');
            new ShowMore('.but');
            new ShowMore('.mission');
        })();
    </script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('frontend.layouts.app', ['current' => 'home'], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\xampp\htdocs\peter-ministries\JBC\peter-ministries\resources\views/frontend/welcome.blade.php ENDPATH**/ ?>