
<?php $__env->startSection('page_title', 'Modifier activité'); ?>
<?php $__env->startSection('breadcrumb'); ?>
    <div class="content-header">
        <div class="container-fluid">
            <div class="row justify-content-end mb-2">
                <div class="col-sm-6">
                    <ol class="breadcrumb float-sm-right">
                        <li class="breadcrumb-item"><a href="<?php echo e(route('dashboard')); ?>">Dashboard</a></li>
                        <li class="breadcrumb-item"><a href="<?php echo e(route('activities.index')); ?>">activités</a></li>
                        <li class="breadcrumb-item active">Modifier activité</li>
                    </ol>
                </div>
            </div>
        </div>
    </div>
<?php $__env->stopSection(); ?>
<?php $__env->startSection('content'); ?>
    <div class="row">
        <div class="col-md-7 mb-3">
            <div class="card">
                <div class="card-header card-outline card-primary">
                    <h3 class="card-title">Informations générales</h3>
                </div>
                <form role="form" method="POST" action="<?php echo e(route('activities.update', $activity)); ?>">
                    <?php echo csrf_field(); ?>
                    <?php echo method_field('PUT'); ?>
                    <div class="card-body">
                        <div class="row">
                            <div class="col-md-12">
                                <div class="form-group">
                                    <label for="name">Nom <span class="text-danger">*</span></label>
                                    <input type="text" name="name" class="form-control" id="name"
                                        value="<?php echo e($activity->title ? $activity->title : old('name')); ?>"
                                        placeholder="Ex. Jus mango" required>
                                    <?php $__errorArgs = ['name'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                        <span class="small text-danger" role="alert"><?php echo e($message); ?></span>
                                    <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                </div>
                            </div>
                        </div>
                        <div class="row">
                            <div class="col-sm-12">
                                <div class="form-group">
                                    <label>Début de l'activité <span class="text-danger">*</span></label>
                                    <div class="input-group">
                                        <div class="input-group-prepend">
                                            <span class="input-group-text"><i class="far fa-calendar-alt"></i></span>
                                        </div>
                                        <input type="date" name="start_date" id="start_date" class="form-control"
                                            placeholder="dd-mm-yyyy"
                                            value="<?php echo e($activity->started_at ? $activity->started_at : old('start_date')); ?>"
                                            required>
                                        <?php $__errorArgs = ['start_date'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                            <span class="small text-danger" role="alert"><?php echo e($message); ?></span>
                                        <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <div class="row">
                            <div class="col-sm-12">
                                <div class="form-group">
                                    <label>Description</label>
                                    <textarea name="description" id="description" class="form-control" rows="5"
                                        placeholder="Ajouter une brève description"><?php echo e($activity->description ? html_entity_decode($activity->description) : old('description')); ?></textarea>
                                    <?php $__errorArgs = ['description'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                        <span class="small text-danger" role="alert"><?php echo e($message); ?></span>
                                    <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                </div>
                            </div>
                        </div>

                        <div class="row">
                            <div class="col small text-danger">
                                Les champs * sont obligatoires
                            </div>
                        </div>
                    </div>
                    <div class="card-footer">
                        <button type="button" class="btn btn-danger" data-toggle="modal"
                            data-target="#activityDeleteModal">
                            <i class="fas fa-trash-alt"></i>
                        </button>
                        <button name="submit" type="submit" class="btn btn-primary float-right">
                            <i class="fas fa-save"></i>
                            Enregistrer
                        </button>
                    </div>
                </form>
            </div>
        </div>

        <div class="col-md-5 mb-3">
            <div class="card">
                <div class="card-header card-outline card-primary">
                    <h3 class="card-title">Ajouter Image</h3>
                </div>
                <form enctype="multipart/form-data" role="form" method="POST"
                    action="<?php echo e(route('store.image', $activity)); ?>">
                    <?php echo csrf_field(); ?>
                    <div class="card-body">
                        <div class="form-group">
                            <div class="input-group">
                                <div class="custom-file">
                                    <input type="file" class="custom-file-input" id="image" name="image"
                                        accept="image/*">
                                    <label class="custom-file-label" for="image">Choisir image</label>
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="card-footer text-right">
                        <button name="submit" type="submit" class="btn btn-primary">
                            <i class="fas fa-save mr-2"></i>
                            Enregistrer
                        </button>
                    </div>
                </form>
            </div>
            <?php if($activity->images->isNotEmpty()): ?>
                <div class="card">
                    <div class="card-header card-outline card-primary">
                        <h3 class="card-title">Les images de l'activité</h3>
                    </div>
                    <div class="card-body table-responsive p-0">
                        <table class="table table-hover  table-sm text-nowrap">
                            <thead class="tbl-head bg-dark-light">
                                <tr>
                                    <th style="width: 5%;">#</th>
                                    <th style="min-width: 30%;">Image</th>
                                    <th style="width: 10%;"></th>
                                </tr>
                            </thead>
                            <tbody>

                                <?php $__empty_1 = true; $__currentLoopData = $activity->images; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $image): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                                    <tr>
                                        <td><?php echo e($loop->iteration); ?>.</td>

                                        <td>
                                            <img class="mr-2"
                                                src="<?php echo e(asset('storage/activities/' . $image->image . '')); ?>"
                                                style="height: 60px; width: 60px; object-fit: cover; object-position: center"
                                                alt="<?php echo e($image->slug); ?>">
                                        </td>
                                        <td class="d-flex justify-content-end">
                                            <a href="<?php echo e(route('delete.image', $image)); ?>">
                                                <i class="fas mr-2 fa-trash text-danger" title="Supprimer"></i>
                                            </a>
                                        </td>
                                    </tr>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                                    <tr>
                                        <td colspan="5" style="text-align: center;">Aucune Image enregistrée!</td>
                                    </tr>
                                <?php endif; ?>
                            </tbody>
                        </table>
                    </div>
                </div>
            <?php endif; ?>
        </div>
    </div>

    <!-- DELETE ACTIVITY MODAL -->
    <form action="<?php echo e(route('activities.destroy', $activity)); ?>" method="POST">
        <?php echo method_field('delete'); ?>
        <?php echo csrf_field(); ?>
        <div class="modal fade" id="activityDeleteModal" tabindex="-1" aria-labelledby="activityDeleteModalLabel"
            aria-hidden="true">
            <div class="modal-dialog">
                <div class="modal-content">
                    <div class="modal-header">
                        <h5 class="modal-title" id="activityDeleteModalLabel">Supprimer activité</h5>
                        <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                            <span aria-hidden="true">&times;</span>
                        </button>
                    </div>
                    <div class="modal-body">
                        <input type="hidden" id="activity_id" name="activity_id">
                        <span>
                            Etes-vous sûr de vouloir supprimer cette activité?
                        </span>
                    </div>
                    <div class="modal-footer">
                        <button type="button" class="btn btn-secondary" data-dismiss="modal">annuler</button>
                        <button type="submit" class="btn btn-danger">Supprimer activité</button>
                    </div>
                </div>
            </div>
        </div>
    </form>
<?php $__env->stopSection(); ?>
<?php $__env->startSection('scripts'); ?>
    <script src="<?php echo e(asset('theme/plugins/bs-custom-file-input/bs-custom-file-input.min.js')); ?>"></script>
    <script>
        $(function() {
            bsCustomFileInput.init();
        });
    </script>
    <?php echo $__env->make('partials._ckeditor', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.default', ['current' => 'activities'], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\xampp\htdocs\peter-ministries\JBC\peter-ministries\resources\views/activities/edit.blade.php ENDPATH**/ ?>