
<?php $__env->startSection('page_title', 'Subscriptions'); ?>
<?php $__env->startSection('breadcrumb'); ?>
    <div class="content-header">
        <div class="container-fluid">
            <div class="row justify-content-end mb-2">
                <div class="col-sm-6">
                    <ol class="breadcrumb float-sm-right">
                        <li class="breadcrumb-item"><a href="<?php echo e(route('dashboard')); ?>">Dashboard</a></li>
                        <li class="breadcrumb-item active">Emails list</li>
                    </ol>
                </div>
            </div>
        </div>
    </div>
<?php $__env->stopSection(); ?>
<?php $__env->startSection('content'); ?>
    <div class="row">
        <div class="col-12">
            <div class="card">
                <div class="card-header">
                    <h2 class="card-title">Emails list</h2>
                </div>
                <div class="card-header">
                    <div class="row justify-content-end">
                        <div class="col-md-2">
                            <div class="input-group input-group-sm">
                                <input type="text" name="table_search" class="form-control float-right"
                                    placeholder="Search">
                                <div class="input-group-append">
                                    <button type="submit" class="btn btn-default">
                                        <i class="fas fa-search"></i>
                                    </button>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="card-body table-responsive p-0">
                    <table class="table table-hover  table-sm text-nowrap">
                        <thead class="tbl-head bg-dark-light">
                            <tr>
                                <th style="width: 5%;">#</th>
                                <th style="min-width: 30%;">Nom</th>
                                <th style="min-width: 30%;">Email</th>
                                <th style="min-width: 30%;">Statut</th>
                                <th style="width: 10%;"></th>
                            </tr>
                        </thead>
                        <tbody>
                            <?php if($subscriptions->isNotEmpty()): ?>
                                <?php $__empty_1 = true; $__currentLoopData = $subscriptions; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $subscription): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                                    <tr>
                                        <td><?php echo e($loop->iteration); ?>.</td>
                                        <td>
                                            <a href="">
                                                <span><?php echo e($subscription->name); ?></span>
                                            </a>
                                        </td>
                                        <td>
                                            <a href="<?php echo e(route('subscriptions.edit', ['subscription' => $subscription])); ?>">
                                                <span><?php echo e($subscription->email); ?></span>
                                            </a>
                                        </td>
                                        <td>
                                            <?php if($subscription->status == 1): ?>
                                                Abonné
                                            <?php else: ?>
                                                Désabonné
                                            <?php endif; ?>
                                        </td>
                                        <td class="d-flex justify-content-end">
                                            <a href="<?php echo e(route('subscriptions.sendEmail', $subscription)); ?>">
                                                <i class="fas mr-2 fa-send text-warning" title="Envoyer"></i>
                                            </a>
                                        </td>
                                    </tr>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                                    <tr>
                                        <td colspan="5" style="text-align: center;">Aucun abonnement enregistré!</td>
                                    </tr>
                                <?php endif; ?>
                            <?php else: ?>
                                <tr>
                                    <td colspan="5" style="text-align: center;">Aucun abonnement enregistré!</td>
                                </tr>
                            <?php endif; ?>
                        </tbody>
                    </table>
                </div>
                <?php if($subscriptions->hasPages()): ?>
                    <div class="card-footer clearfix">
                        <ul class="pagination pagination-sm m-0 float-right">
                            <li class="page-item">
                                <a class="btn btn-default btn-sm <?php echo e($subscriptions->onFirstPage() ? 'disabled' : null); ?>"
                                    href="<?php echo e($subscriptions->previousPageUrl()); ?>">&laquo;</a>
                            </li>
                            <li class="page-item">
                                <a href="<?php echo e($subscriptions->nextPageUrl()); ?>"
                                    class="btn btn-default btn-sm <?php echo e(!$subscriptions->hasMorePages() ? 'disabled' : null); ?>">&raquo;</a>
                            </li>
                        </ul>
                    </div>
                <?php endif; ?>
            </div>
        </div>
    </div>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.default', ['current' => 'subscriptions'], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\xampp\htdocs\peter-ministries\JBC\peter-ministries\resources\views/subscriptions/index.blade.php ENDPATH**/ ?>