
<?php $__env->startSection('page_title', 'Settings'); ?>
<?php $__env->startSection('breadcrumb'); ?>
    <div class="content-header">
        <div class="container-fluid">
            <div class="row justify-content-end mb-2">
                <div class="col-sm-6">
                    <ol class="breadcrumb float-sm-right">
                        <li class="breadcrumb-item"><a href="#">Dashboard</a></li>
                        <li class="breadcrumb-item active">Settings</li>
                    </ol>
                </div>
            </div>
        </div>
    </div>
<?php $__env->stopSection(); ?>
<?php $__env->startSection('content'); ?>
    <div class="row">
        <div class="col-12">
            <div class="card">
                <div class="card-header">
                    <h2 class="card-title">Settings</h2>
                    <?php if($settings->count() < 1): ?>
                        <div class="card-tools">
                            <button type="button" class="btn btn-primary" data-toggle="modal" data-target="#settingModal">
                                <i class="fas fa-plus mr-2"></i>
                                Ajouter
                            </button>
                        </div>
                    <?php endif; ?>
                </div>
                
                <div class="card-body table-responsive p-0">
                    <table class="table table-hover table-sm text-nowrap" id="settingTable">
                        <thead class="tbl-head bg-dark-light">
                        <tr>
                            <th style="width: 5%;">#</th>
                            <th style="min-width: 20%;">AirtelMoney</th>
                            <th style="min-width: 20%;">OrangeMoney</th>
                            <th style="min-width: 20%;">Mpesa</th>
                            <th style="min-width: 20%;">BankName</th>
                            <th style="min-width: 10%;">BankAccount</th>
                            <th style="width: 10%;"></th>
                        </tr>
                        </thead>
                        <tbody>
                        <?php if($settings->isNotEmpty()): ?>
                            <?php $__empty_1 = true; $__currentLoopData = $settings; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $setting): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                                <tr>
                                    <td><?php echo e($loop->iteration); ?>.</td>
                                    <td>
                                        <span><?php echo e($setting->airtelmoney); ?></span>
                                    </td>
                                    <td>
                                        <?php echo e($setting->orangemoney); ?>

                                    </td>
                                    <td>
                                        <?php echo e($setting->mpesa); ?>

                                    </td>
                                    <td>
                                        <?php echo e($setting->bankname); ?>

                                    </td>
                                    <td>
                                        <?php echo e($setting->bankaccount); ?>

                                    </td>
                                    <td class="d-flex justify-content-end">
                                        <a href="<?php echo e(route('settings.edit', $setting)); ?>">
                                            <i class="fas mr-2 fa-edit text-warning" title="Modifier"></i>
                                        </a>
                                    </td>
                                </tr>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                                <tr>
                                    <td colspan="7" style="text-align: center;">Aucune setting enregistrée!</td>
                                </tr>
                            <?php endif; ?>
                        <?php else: ?>    
                            <tr>
                                <td colspan="7" style="text-align: center;">Aucune setting enregistrée!</td>
                            </tr>
                        <?php endif; ?>

                        </tbody>
                    </table>
                </div>
            </div>
        </div>
    </div>

    
    <form action="<?php echo e(route('settings.store')); ?>" method="POST" enctype="multipart/form-data" autocomplete="off">
        <?php echo csrf_field(); ?>
        <div class="modal fade" id="settingModal" tabindex="-1" aria-labelledby="settingModal"
             aria-hidden="true">
            <div class="modal-dialog modal-sm">
                <div class="modal-content" style="width: 500px;">
                    <div class="modal-header">
                        <h5 class="modal-title" id="settingModal">AJOUTER </h5>
                        <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                            <span aria-hidden="true">&times;</span>
                        </button>
                    </div>
                    <div class="modal-body">
                        <div class="row">
                            <div class="col-md-12">
                                <div class="form-group">
                                    <label for="airtelmoney">AirtelMoney</label>
                                    <input type="text" name="airtelmoney" class="form-control" id="airtelmoney" required
                                           placeholder="ex : +243...">
                                </div>
                            </div>
                        </div>
                        <div class="row">
                            <div class="col-md-6">
                                <div class="form-group">
                                    <label for="orangemoney">OrangeMoney</label>
                                    <input type="text" name="orangemoney" class="form-control" id="orangemoney" required
                                           placeholder="ex : +243...">
                                </div>
                            </div>
                            <div class="col-md-6">
                                <div class="form-group">
                                    <label for="mpesa">Mpesa</label>
                                    <input type="text" name="mpesa" class="form-control" id="mpesa" required
                                           placeholder="ex : +243...">
                                </div>
                            </div>
                        </div>
                        <div class="row">
                            <div class="col-md-6">
                                <div class="form-group">
                                    <label for="bankname">BankName</label>
                                    <input type="text" name="bankname" class="form-control" id="bankname" required
                                           placeholder="ex : FBN Bank">
                                </div>
                            </div>
                            <div class="col-md-6">
                                <div class="form-group">
                                    <label for="bankaccount">BankAccount</label>
                                    <input type="text" name="bankaccount" class="form-control" id="bankaccount" required
                                           placeholder="ex : 003034...">
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="modal-footer ">
                        <button type="button" class="btn btn-secondary" data-dismiss="modal">Annuler</button>
                        <button type="submit" class="btn btn-primary">
                            <i class="fas fa-save mr-2"></i>
                            Enregistrer
                        </button>
                    </div>
                </div>
            </div>
        </div>
    </form>
<?php $__env->stopSection(); ?>







<?php echo $__env->make('layouts.default', ['current' => 'settings'], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\xampp\htdocs\peter-ministries\JBC\peter-ministries\resources\views/settings/index.blade.php ENDPATH**/ ?>